//
//  BaseTableViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/3.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class BaseTableViewController: UITableViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        if #available(iOS 11.0, *) {
            tableView.contentInsetAdjustmentBehavior = .never
        }
        automaticallyAdjustsScrollViewInsets = false
    }
    
    // MARK: - 生成随机字符串
    open func randomMD5() -> String {
        let identifier = CFUUIDCreate(nil)
        let identifierString = CFUUIDCreateString(nil, identifier) as String
        let cStr = identifierString.cString(using: .utf8)
        var digest = [UInt8](repeating: 0, count: Int(CC_MD5_DIGEST_LENGTH))
        CC_MD5(cStr, CC_LONG(strlen(cStr)), &digest)
        var output = String()
        for i in digest {
            output = output.appendingFormat("%02X", i)
        }
        return output;
    }
    
    
    // MARK: - 保存图片附件至沙盒
    open func saveImage(currentImage: UIImage, persent: CGFloat, imageName: String) ->String {
        if let imageData = UIImageJPEGRepresentation(currentImage, persent) as NSData? {
            let fullPath = NSHomeDirectory().appending("/Documents/Files").appending(imageName)
            imageData.write(toFile: fullPath, atomically: true)
            return fullPath
        }
        return ""
    }
}
