//
//    UserModel.swift
//
//    Create by 云霄 曹 on 8/1/2018
//    Copyright © 2018. All rights reserved.
//    Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation
import SwiftyJSON


public class UserModel : NSObject, NSCoding{
    
    var authenticode : String!
    var belongOrgIsLeaf : Bool!
    var belongOrgPath : String!
    var enterpriseCode : String!
    var enterpriseName : String!
    var enterpriseUuid : String!
    var orgCode : String!
    var orgName : String!
    var orgUuid : String!
    var permissions : [String]!
    var position : AnyObject!
    var userCode : String!
    var userName : String!
    var userUuid : String!
    var password: String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        authenticode = json["authenticode"].stringValue
        belongOrgIsLeaf = json["belongOrgIsLeaf"].boolValue
        belongOrgPath = json["belongOrgPath"].stringValue
        enterpriseCode = json["enterprise_code"].stringValue
        enterpriseName = json["enterprise_name"].stringValue
        enterpriseUuid = json["enterprise_uuid"].stringValue
        orgCode = json["org_code"].stringValue
        orgName = json["org_name"].stringValue
        orgUuid = json["org_uuid"].stringValue
        permissions = [String]()
        let permissionsArray = json["permissions"].arrayValue
        for permissionsJson in permissionsArray{
            permissions.append(permissionsJson.stringValue)
        }
        position = json["position"].stringValue as AnyObject
        userCode = json["user_code"].stringValue
        userName = json["user_name"].stringValue
        userUuid = json["user_uuid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if authenticode != nil{
            dictionary["authenticode"] = authenticode
        }
        if belongOrgIsLeaf != nil{
            dictionary["belongOrgIsLeaf"] = belongOrgIsLeaf
        }
        if belongOrgPath != nil{
            dictionary["belongOrgPath"] = belongOrgPath
        }
        if enterpriseCode != nil{
            dictionary["enterprise_code"] = enterpriseCode
        }
        if enterpriseName != nil{
            dictionary["enterprise_name"] = enterpriseName
        }
        if enterpriseUuid != nil{
            dictionary["enterprise_uuid"] = enterpriseUuid
        }
        if orgCode != nil{
            dictionary["org_code"] = orgCode
        }
        if orgName != nil{
            dictionary["org_name"] = orgName
        }
        if orgUuid != nil{
            dictionary["org_uuid"] = orgUuid
        }
        if permissions != nil{
            dictionary["permissions"] = permissions
        }
        if position != nil{
            dictionary["position"] = position
        }
        if userCode != nil{
            dictionary["user_code"] = userCode
        }
        if userName != nil{
            dictionary["user_name"] = userName
        }
        if userUuid != nil{
            dictionary["user_uuid"] = userUuid
        }
        
        return dictionary
    }
    
    /**
     * NSCoding required initializer.
     * Fills the data from the passed decoder
     */
    @objc required public init(coder aDecoder: NSCoder)
    {
        authenticode = aDecoder.decodeObject(forKey: "authenticode") as? String
        belongOrgIsLeaf = aDecoder.decodeObject(forKey: "belongOrgIsLeaf") as? Bool
        belongOrgPath = aDecoder.decodeObject(forKey: "belongOrgPath") as? String
        enterpriseCode = aDecoder.decodeObject(forKey: "enterprise_code") as? String
        enterpriseName = aDecoder.decodeObject(forKey: "enterprise_name") as? String
        enterpriseUuid = aDecoder.decodeObject(forKey: "enterprise_uuid") as? String
        orgCode = aDecoder.decodeObject(forKey: "org_code") as? String
        orgName = aDecoder.decodeObject(forKey: "org_name") as? String
        orgUuid = aDecoder.decodeObject(forKey: "org_uuid") as? String
        permissions = aDecoder.decodeObject(forKey: "permissions") as? [String]
        position = aDecoder.decodeObject(forKey: "position") as AnyObject
        userCode = aDecoder.decodeObject(forKey: "user_code") as? String
        userName = aDecoder.decodeObject(forKey: "user_name") as? String
        userUuid = aDecoder.decodeObject(forKey: "user_uuid") as? String
        password = aDecoder.decodeObject(forKey: "password") as? String
    }
    
    /**
     * NSCoding required method.
     * Encodes mode properties into the decoder
     */
    public func encode(with aCoder: NSCoder)
    {
        if authenticode != nil{
            aCoder.encode(authenticode, forKey: "authenticode")
        }
        if belongOrgIsLeaf != nil{
            aCoder.encode(belongOrgIsLeaf, forKey: "belongOrgIsLeaf")
        }
        if belongOrgPath != nil{
            aCoder.encode(belongOrgPath, forKey: "belongOrgPath")
        }
        if enterpriseCode != nil{
            aCoder.encode(enterpriseCode, forKey: "enterprise_code")
        }
        if enterpriseName != nil{
            aCoder.encode(enterpriseName, forKey: "enterprise_name")
        }
        if enterpriseUuid != nil{
            aCoder.encode(enterpriseUuid, forKey: "enterprise_uuid")
        }
        if orgCode != nil{
            aCoder.encode(orgCode, forKey: "org_code")
        }
        if orgName != nil{
            aCoder.encode(orgName, forKey: "org_name")
        }
        if orgUuid != nil{
            aCoder.encode(orgUuid, forKey: "org_uuid")
        }
        if permissions != nil{
            aCoder.encode(permissions, forKey: "permissions")
        }
        if position != nil{
            aCoder.encode(position, forKey: "position")
        }
        if userCode != nil{
            aCoder.encode(userCode, forKey: "user_code")
        }
        if userName != nil{
            aCoder.encode(userName, forKey: "user_name")
        }
        if userUuid != nil{
            aCoder.encode(userUuid, forKey: "user_uuid")
        }
        if password != nil{
            aCoder.encode(password, forKey: "password")
        }
    }
}

