//
//  LoginViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/8.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import Moya

class LoginViewModel: BaseViewModel {

    /// 登录
    ///
    /// - Parameters:
    ///   - login: 用户名
    ///   - password: 密码
    func loginRequest(_ login: String, _ password: String) ->Observable<String> {
        let userName = NSString(string: login).format()
        let passWord = NSString(string: password).format()
        return Observable.create({(observer) -> Disposable in
            Network.request(target: .Login(userName!, passWord!.md5()), success: {(json) in
                let model = LoginResultModel(fromJson: json)
                if model.success {
                    model.data.password = password
                    AppManager.shareInstance.userModel = model.data
                    LoginViewModel.archiveAccountInformation()
                    observer.onNext(json.description)
                }else {
                    ShowMessage(model.message)
                }
            }) { (error) in
                ShowMessage(error.localizedDescription)
            }
            return Disposables.create()
        })
    }
    
    // MARK: - 归档用户信息
    open class func archiveAccountInformation() {
       let bool = NSKeyedArchiver.archiveRootObject(kUser(), toFile: accountPath)
        if bool {
            print("归档成功")
        }else {
            print("归档失败")
        }
    }
    
    // MARK: - 解档用户信息
    open class func unarchiveAccountInformation() {
        let account = NSKeyedUnarchiver.unarchiveObject(withFile: accountPath) as? UserModel
        AppManager.shareInstance.userModel = account
    }
}















