//
//  TodoViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/5.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxCocoa
import RxSwift
import SwiftyJSON

class TodoViewController: BaseTableViewPullController {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    
    /// TodoViewModel
    lazy final var todoViewModel: TodoViewModel = {
        var todoViewModel = TodoViewModel()
        return todoViewModel
    }()
    
    /// 工单详情ViewModel
    lazy final var orderDetailViewModel: RepairOrderDetailViewModel = {
        var orderDetailViewModel = RepairOrderDetailViewModel()
        return orderDetailViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        tableViewAnimationHeight()
    }

    // MARK: - 加载数据
    override func loadWebDataSource() {
        todoViewModel.queryTodoAction(.ALL).subscribe {[weak self] (event) in
            switch event {
            case .next():
                self?.endRefreshNomoreData()
                break
            case .error(_):
                self?.endRefresh()
                break
            default:
                break
            }
            self?.tableView.reloadData()
            }.disposed(by: disposeBag)
    }
    
    // MARK: - 设置tableview高度
    fileprivate func tableViewAnimationHeight() {
        tableView.rowHeight = UITableViewAutomaticDimension
        tableView.estimatedRowHeight = 80.0
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        return todoViewModel.dequeueReusableCell(TodoTableViewCell.name(),indexPath,tableView)
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return todoViewModel.todoResultArray.count
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        let model = todoViewModel.todoResultArray[indexPath.row]
        switch model.state {
        case SUBMIT_REPAIR_ORDER_STATE.INIT.rawValue:
            if !PermissionsManager.drawChildPermissions() {
                ShowMessage("当前用户对此工单没有领取权限!")
                return
            }
            ShowAlertView(hint, "请确认是否领单?", [cancel,sure], .alert, {[weak self] (index) in
                if index == kZERO { return }
                self?.orderDetailViewModel.getChildBillAction(model.uuid).subscribe(onNext: { () in
                    self?.loadWebDataSource()
                    ShowMessage("领取成功")
                }).disposed(by: self!.disposeBag)
            })
            break
        case SUBMIT_REPAIR_ORDER_STATE.DREW.rawValue:
            if !PermissionsManager.saveChildPermissions() {
                ShowMessage("当前用户对此工单没有编辑权限!")
                return;
            }
            let childBillVc = RepairOrderEditSonOrderViewController.instantiateViewController(.Function) as! RepairOrderEditSonOrderViewController
            childBillVc.billModel = BillDetailExecute(fromJson: JSON(model.toDictionary()))
            pushVC(childBillVc)
            break
        case SUBMIT_REPAIR_ORDER_STATE.DONE.rawValue,SUBMIT_REPAIR_ORDER_STATE.CANCLED.rawValue:
            if !PermissionsManager.childViewPermissions() {
                ShowMessage("当前用户对此工单没有查看权限!")
                return;
            }
            let childBillVc = RepairOrderChildBillDetailViewController.instantiateViewController(.Function) as! RepairOrderChildBillDetailViewController
            childBillVc.billModel = BillDetailExecute(fromJson: JSON(model.toDictionary()))
            pushVC(childBillVc)
            break
        default:
            break
        }
    }
}

















