//
//  ReparirChildBillViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/8.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import RxCocoa
import Moya

class ReparirChildBillViewModel: BaseViewModel {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    
    /// 过滤ViewModel
    lazy final var filterViewModel: FilterViewModel = {
        var filterViewModel = FilterViewModel()
        return filterViewModel
    }()
    
    /// 子单详情
    lazy final var childBillDetailData: ChildBillDetailData = {
        var childBillDetailData = ChildBillDetailData(SUBMIT_REPAIR_ORDER_STATE.PROCESSING.rawValue)
        return childBillDetailData
    }()
}

extension ReparirChildBillViewModel {
    
    /// 查询子工单详情
    func queryChildBillDetailAction(_ billUuid: String) ->Observable<Void>{
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .GetChildBillDetail(billUuid), success: {[weak self] (json) in
                let resultModel = ChildBillDetailResultModel(fromJson: json)
                if resultModel.success {
                    if let model = resultModel.data {
                        self?.childBillDetailData = model
                        observer.onNext(())
                    }else {
                        ShowMessage(resultModel.message)
                        observer.onError(MoyaError.requestMapping(resultModel.message))
                    }
                }else {
                    ShowMessage(resultModel.message)
                    observer.onError(MoyaError.requestMapping(resultModel.message))
                }
                }, failure: { (error) in
                    ShowMessage(error.localizedDescription)
                    observer.onError(MoyaError.requestMapping(error.localizedDescription))
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 保存子工单
    func saveChildBillAction() ->Observable<Void> {
        childBillDetailData.createTime = nil
        childBillDetailData.createId = nil
        childBillDetailData.createOperName = nil
        childBillDetailData.lastModifyTime = nil
        childBillDetailData.lastModifyId = nil
        childBillDetailData.lastModifyOperName = nil
        childBillDetailData.executeOutsources = []
        childBillDetailData.executeMateriels = []
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .SaveChildBill(self.childBillDetailData), success: { (json) in
                let resultModel = PublicResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(())
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 完成子工单
    func finishChildBillAction() ->Observable<Void> {
        childBillDetailData.createTime = nil
        childBillDetailData.createId = nil
        childBillDetailData.createOperName = nil
        childBillDetailData.lastModifyTime = nil
        childBillDetailData.lastModifyId = nil
        childBillDetailData.lastModifyOperName = nil
        childBillDetailData.executeOutsources = []
        childBillDetailData.executeMateriels = []
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .FinishChildBill(self.childBillDetailData), success: { (json) in
                let resultModel = PublicResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(())
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 子工单上传附件
    func childBillUploadAttachmentAction(_ beforArray: Array<UploadPhotoAttachmentModel>?,_ afterArray: Array<UploadPhotoAttachmentModel>?) ->Observable<(Void,Void)> {
        return Observable.zip(childBillAfterAttachmentUpload(afterArray!),childBillBeforAttachmentUpload(beforArray!))
    }
    
    // MARK: -维修后附件上传
    func childBillAfterAttachmentUpload(_ array: Array<UploadPhotoAttachmentModel>?) ->Observable<Void> {
        return Observable.create({ (observer) -> Disposable in
            if !array!.isEmpty {
                for i in 0..<array!.count {
                    let model = array![i]
                    Network.request(target: .UploadAttachment(model), success: { (json) in
                        let resultModel = PublicResultModel(fromJson: json)
                        if resultModel.success {
                            if i == array!.count - kONE {
                                observer.onNext(())
                            }
                        }else {
                            ShowMessage(resultModel.message)
                        }
                    }, failure: { (error) in
                        ShowMessage(error.localizedDescription)
                    })
                }
            }else {
                observer.onNext(())
            }
            return Disposables.create()
        })
    }
    
    // MARK: -维修前附件上传
    func childBillBeforAttachmentUpload(_ array: Array<UploadPhotoAttachmentModel>?) ->Observable<Void> {
        return Observable.create({ (observer) -> Disposable in
            if !array!.isEmpty {
                for i in 0..<array!.count {
                    let model = array![i]
                    Network.request(target: .UploadAttachment(model), success: { (json) in
                        let resultModel = PublicResultModel(fromJson: json)
                        if resultModel.success {
                            if i == array!.count - kONE {
                                observer.onNext(())
                            }
                        }else {
                            ShowMessage(resultModel.message)
                        }
                    }, failure: { (error) in
                        ShowMessage(error.localizedDescription)
                    })
                }
            }else {
                observer.onNext(())
            }
            return Disposables.create()
        })
    }
    
    // MARK: - 下载维修前图片附件
    func downloadBeforAttachmentAction(_ entityUuid: String) ->Observable<[AttachmentData]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .DownloadAttachment(ATTACHMENT_TYPE.CHILD_BILL_ATTACHMENT_TYPE.rawValue,entityUuid), success: { (json) in
                let resultModel = AttachmentResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 下载维修后图片附件
    func downloadAafterAttachmentAction(_ entityUuid: String) ->Observable<[AttachmentData]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .DownloadAttachment(ATTACHMENT_TYPE.CHILD_BILL_ATTACHMENT_TYPE.rawValue,entityUuid), success: { (json) in
                let resultModel = AttachmentResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
            })
            return Disposables.create()
        })
    }
}

extension ReparirChildBillViewModel {
    
    // MARK: - 子工单赋值.编辑
    func childBillDetailAssignment(_ controller: RepairOrderEditSonOrderViewController) {
        controller.toolOptionLabel.text = disposeEmpty(childBillDetailData.property1)
        controller.protectOptionLabel.text = disposeEmpty(childBillDetailData.property2)
        controller.workPersonLabel.text = disposeEmpty(childBillDetailData.processor)
        controller.placeTimeLabel.text = disposeEmpty(childBillDetailData.processBegin)
        controller.leaveTimeLabel.text = disposeEmpty(childBillDetailData.processEnd)
        controller.failureCauseLabel.text = disposeEmpty(childBillDetailData.reason)
        controller.processModeLabel.text = disposeEmpty(childBillDetailData.processMode)
        controller.costLaborText.text = childBillDetailData.labourfee.isEmpty ? nil : childBillDetailData.labourfee
        controller.materialCostLabel.text = disposeEmpty(childBillDetailData.materielfee)
        controller.describeTextView.text = childBillDetailData.note.isEmpty ? nil : childBillDetailData.note
    }
    
    // MARK: - 子工单赋值.查看
    func childBillDetailAssignment(_ controller: RepairOrderChildBillDetailViewController) {
        controller.workPersonLabel.text = disposeEmpty2(childBillDetailData.processor)
        controller.placeTimeLabel.text = disposeEmpty2(childBillDetailData.processBegin)
        controller.leaveTimeLabel.text = disposeEmpty2(childBillDetailData.processEnd)
        controller.failureCauseLabel.text = disposeEmpty2(childBillDetailData.reason)
        controller.processModeLabel.text = disposeEmpty2(childBillDetailData.processMode)
        if childBillDetailData.owner != nil {
            controller.operatorNameLabel.text = disposeEmpty2(childBillDetailData.owner.name)
        }
        controller.materialCostLabel.text = disposeEmpty2(childBillDetailData.materielfee)
        controller.costLaborLabel.text = disposeEmpty2(childBillDetailData.labourfee)
        controller.describeLabel.text = disposeEmpty2(childBillDetailData.note)
        controller.safetyProtectionLabel.text = disposeEmpty2(childBillDetailData.property2)
        controller.backupsToolLabel.text = disposeEmpty2(childBillDetailData.property1)
        controller.billNumberTimeLabel.text = disposeEmpty2(childBillDetailData.ownerTime)
        controller.billNumberLab.text = disposeEmpty2(childBillDetailData.executeNo)
    }
    
    // MARK: - 处理空数据
    func disposeEmpty(_ string: String) ->String? {
        if string.isEmpty {
            return "请选择"
        }
        return string
    }
    
    // MARK: - 处理空数据
    func disposeEmpty2(_ string: String) ->String? {
        if string.isEmpty {
            return "---"
        }
        return string
    }
    
    // MARK: - 工单详情状态处理
    func billDetailStataDispose(_ controller: RepairOrderChildBillDetailViewController) {
        switch childBillDetailData.state {
        case SUBMIT_REPAIR_ORDER_STATE.INIT.rawValue:
            controller.createdStateImg.image = UIImage(named: "state_selected")
            controller.createStateLab.text = repairOrderChineseState(childBillDetailData.state)
            controller.createStateLab.textColor = kBlueColor
            
            controller.processedStateImg.image = UIImage(named: "state_default")
            controller.processedStateLab.textColor = kLightGaryColor
            
            controller.completedStateImg.image = UIImage(named: "state_default")
            controller.completedStateLab.textColor = kLightGaryColor
            break
        case SUBMIT_REPAIR_ORDER_STATE.DREW.rawValue:
            
            controller.createdStateImg.image = UIImage(named: "state_default")
            controller.createStateLab.textColor = kLightGaryColor
            
            controller.processedStateImg.image = UIImage(named: "state_selected")
            controller.processedStateLab.textColor = kBlueColor
            
            controller.completedStateImg.image = UIImage(named: "state_default")
            controller.completedStateLab.textColor = kLightGaryColor
            break
        case SUBMIT_REPAIR_ORDER_STATE.PROCESSING.rawValue:
            
            controller.createdStateImg.image = UIImage(named: "state_default")
            controller.createStateLab.textColor = kLightGaryColor
            
            controller.processedStateImg.image = UIImage(named: "state_selected")
            controller.processedStateLab.textColor = kBlueColor
            
            controller.completedStateImg.image = UIImage(named: "state_default")
            controller.completedStateLab.textColor = kLightGaryColor
            break
        case SUBMIT_REPAIR_ORDER_STATE.DONE.rawValue:
            
            controller.createdStateImg.image = UIImage(named: "state_default")
            controller.createStateLab.textColor = kLightGaryColor
            
            controller.processedStateImg.image = UIImage(named: "state_default")
            controller.processedStateLab.textColor = kLightGaryColor
            
            controller.completedStateImg.image = UIImage(named: "state_selected")
            controller.completedStateLab.textColor = kBlueColor
            break
        default:
            break
        }
    }
    
    /// 完成部门工单界面item对应事件
    func didSelectRowAtIndexPath(_ indexPath: IndexPath, _ controller: RepairOrderEditSonOrderViewController) {
        switch indexPath {
        case IndexPath(row: 0, section: 0):
            filterViewModel.queryToolOption().subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                YXPickerManager.share().showGeneralPickerView(kMainColor, dataArray: result, defaultString: controller.toolOptionLabel.text, commit: { (text, index) in
                    controller.toolOptionLabel.text = text
                    controller.toolOptionLabel.textColor = kBlackColor
                    self?.childBillDetailData.property1 = text
                }, cancel: nil)
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 1, section: 0):
            filterViewModel.queryProtectOption().subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                YXPickerManager.share().showGeneralPickerView(kMainColor, dataArray: result, defaultString: controller.protectOptionLabel.text, commit: { (text, index) in
                    controller.protectOptionLabel.text = text
                    controller.protectOptionLabel.textColor = kBlackColor
                    self?.childBillDetailData.property2 = text
                }, cancel: nil)
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 2, section: 0):
            let model = QueryModel()
            model.storeUuidEquals = childBillDetailData.dept.uuid
            filterViewModel.queryInitiator(model).subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                let publicFilterVc = FilterViewController.instantiateViewController(.Function) as! FilterViewController
                for model in result {
                    let filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kZERO)")
                    publicFilterVc.publicViewModel.filterArray.add(filterModel)
                }
                controller.pushVC(publicFilterVc)
                publicFilterVc.setNavigationTitle("选择出工人",.SINGLE, { (choices, index) in
                    let choiceModel = choices.first!
                    controller.workPersonLabel.text = choiceModel.title
                    controller.workPersonLabel.textColor = kBlackColor
                    let model = result[index!]
                    self?.childBillDetailData.processor = model.name
                })
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 3, section: 0):
            let defaultDate = controller.placeTimeLabel.text == "请选择" ? NSDate().httpParameterString() : controller.placeTimeLabel.text
            var date: Date?
            if !childBillDetailData.processEnd.isEmpty {
                date = Date(fromString: childBillDetailData.processEnd, format: "yyyy-MM-dd HH:mm:ss")!
            }
            YXPickerManager.share().showDatePickerView(kMainColor, datePickerModel: UIDatePickerMode.dateAndTime, minimumDate: Date(), maximumDate: date, defaultDate: defaultDate, commit: {[weak self] (time) in
                controller.placeTimeLabel.text = time
                controller.placeTimeLabel.textColor = kBlackColor
                self?.childBillDetailData.processBegin = time
                }, cancel: nil)
            break
        case IndexPath(row: 4, section: 0):
            let defaultDate = controller.leaveTimeLabel.text == "请选择" ? NSDate().httpParameterString() : controller.leaveTimeLabel.text
            var date = Date()
            if !childBillDetailData.processBegin.isEmpty {
                date = Date(fromString: childBillDetailData.processBegin, format: "yyyy-MM-dd HH:mm:ss")!
            }
            YXPickerManager.share().showDatePickerView(kMainColor, datePickerModel: UIDatePickerMode.dateAndTime, minimumDate: date, maximumDate: nil, defaultDate: defaultDate, commit: {[weak self] (time) in
                controller.leaveTimeLabel.text = time
                controller.leaveTimeLabel.textColor = kBlackColor
                self?.childBillDetailData.processEnd = time
                }, cancel: nil)
            break
        case IndexPath(row: 5, section: 0):
            filterViewModel.queryBrokenOption().subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                YXPickerManager.share().showGeneralPickerView(kMainColor, dataArray: result, defaultString: controller.failureCauseLabel.text, commit: { (text, index) in
                    controller.failureCauseLabel.text = text
                    controller.failureCauseLabel.textColor = kBlackColor
                    self?.childBillDetailData.reason = text
                }, cancel: nil)
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 6, section: 0):
            filterViewModel.queryProcessMethods().subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                YXPickerManager.share().showGeneralPickerView(kMainColor, dataArray: result, defaultString: controller.processModeLabel.text, commit: { (text, index) in
                    controller.processModeLabel.text = text
                    controller.processModeLabel.textColor = kBlackColor
                    self?.childBillDetailData.processMode = text
                }, cancel: nil)
            }).disposed(by: disposeBag)
            break
        default:
            break
        }
    }
    
    // MARK: - 工单详情分区信息
    func dequeueReusableHeaderFooterView(_ identifier: String, _ tableView: UITableView, _ section: Int) ->UIView? {
        let sectionView = tableView.dequeueReusableHeaderFooterView(withIdentifier: RepairOrderDetailSectionView.name()) as! RepairOrderDetailSectionView
        switch section {
        case CHILD_BILL_DETAIL_SECTION.SOURCE.rawValue:
            sectionView.sectionStateLabel.text = "创建"
            sectionView.stateTimeLabel.text = childBillDetailData.createTime
            break
        case CHILD_BILL_DETAIL_SECTION.COST.rawValue:
            sectionView.sectionStateLabel.text = "费用信息"
            sectionView.stateTimeLabel.text = nil
            break
        case CHILD_BILL_DETAIL_SECTION.BORROW.rawValue:
            sectionView.sectionStateLabel.text = "借用信息"
            sectionView.stateTimeLabel.text = nil
            break
        case CHILD_BILL_DETAIL_SECTION.DESCRIBE.rawValue:
            sectionView.sectionStateLabel.text = "描述信息"
            sectionView.stateTimeLabel.text = childBillDetailData.lastModifyTime
            break
        default:
            break
        }
        return sectionView
    }
}
