//
//  CostOrBorrowTableViewCell.swift
//  IFS
//
//  Created by 曹云霄 on 2018/3/12.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class CostOrBorrowTableViewCell: UITableViewCell {

    /// item 标题
    @IBOutlet weak var titleLabel: UILabel!
    
    /// item 详情
    @IBOutlet weak var detailLabel: UILabel!
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
    }

    // MARK: - 更新cell
    open func updateCell(_ model: ExecuteMateriel,_ indexPath: IndexPath) {
        if model.materiel != nil {
            titleLabel.text = model.materiel.name
        }
        if model.sourceType == CHILDORDERCOST_TYPE.BORROW.rawValue {
            detailLabel.text = model.outputbillno
        }else {
            detailLabel.text = String(format: "%.2f", model.unitPrice * (model.getQty - model.backQty))
        }
    }
}
