//
//	RootClass.swift
//
//	Create by 云霄 曹 on 11/1/2018
//	Copyright © 2018. All rights reserved.

import Foundation 
import SwiftyJSON


class RepairOrderResultModel : NSObject{

	var data : RepairOrderData!
	var message : String!
	var success : Bool!

	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		let dataJson = json["data"]
		if !dataJson.isEmpty{
			data = RepairOrderData(fromJson: dataJson)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			dictionary["data"] = data.toDictionary()
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}
}

class RepairOrderData : NSObject{
    
    var paging : Paging!
    var records : [RepairOrderRecord]!
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        let pagingJson = json["paging"]
        if !pagingJson.isEmpty{
            paging = Paging(fromJson: pagingJson)
        }
        records = [RepairOrderRecord]()
        let recordsArray = json["records"].arrayValue
        for recordsJson in recordsArray{
            let value = RepairOrderRecord(fromJson: recordsJson)
            records.append(value)
        }
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if paging != nil{
            dictionary["paging"] = paging.toDictionary()
        }
        if records != nil{
            var dictionaryElements = [[String:Any]]()
            for recordsElement in records {
                dictionaryElements.append(recordsElement.toDictionary())
            }
            dictionary["records"] = dictionaryElements
        }
        return dictionary
    }
}

class RepairOrderRecord : NSObject{
    
    var attachmentId : String!
    var attachments : AnyObject!
    var brokenTime : AnyObject!
    var cancleReason : AnyObject!
    var cancleTime : AnyObject!
    var cancleUser : AnyObject!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var descriptionField : String!
    var device : UCN!
    var deviceType : AnyObject!
    var executes : [RepairOrderExecute]!
    var feedback : AnyObject!
    var feedbackNote : AnyObject!
    var finish : Bool!
    var finishNote : AnyObject!
    var finishTime : AnyObject!
    var finishUser : AnyObject!
    var labourfee : AnyObject!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var level : String!
    var materielfee : AnyObject!
    var note : String!
    var position : UCN!
    var receiveTime : String!
    var reportOrg : String!
    var reportUser : UCN!
    var reporterPhone : String!
    var requestTime : String!
    var serviceType : String!
    var source : String!
    var state : String!
    var store : AnyObject!
    var tenant : UCN!
    var uuid : String!
    var version : Int!
    var workNo : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        attachmentId = json["attachmentId"].stringValue
        attachments = json["attachments"] as AnyObject
        brokenTime = json["brokenTime"].stringValue as AnyObject
        cancleReason = json["cancleReason"] as AnyObject
        cancleTime = json["cancleTime"] as AnyObject
        cancleUser = json["cancleUser"] as AnyObject
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        descriptionField = json["description"].stringValue
        let deviceJson = json["device"]
        if !deviceJson.isEmpty{
            device = UCN(fromJson: deviceJson)
        }
        deviceType = json["deviceType"].stringValue as AnyObject
        executes = [RepairOrderExecute]()
        let executesArray = json["executes"].arrayValue
        for executesJson in executesArray{
            let value = RepairOrderExecute(fromJson: executesJson)
            executes.append(value)
        }
        feedback = json["feedback"] as AnyObject
        feedbackNote = json["feedbackNote"] as AnyObject
        finish = json["finish"].boolValue
        finishNote = json["finishNote"] as AnyObject
        finishTime = json["finishTime"] as AnyObject
        finishUser = json["finishUser"] as AnyObject
        labourfee = json["labourfee"] as AnyObject
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        level = json["level"].stringValue
        materielfee = json["materielfee"] as AnyObject
        note = json["note"].stringValue
        let positionJson = json["position"]
        if !positionJson.isEmpty{
            position = UCN(fromJson: positionJson)
        }
        receiveTime = json["receiveTime"].stringValue
        reportOrg = json["reportOrg"].stringValue
        let reportUserJson = json["reportUser"]
        if !reportUserJson.isEmpty{
            reportUser = UCN(fromJson: reportUserJson)
        }
        reporterPhone = json["reporterPhone"].stringValue
        requestTime = json["requestTime"].stringValue
        serviceType = json["serviceType"].stringValue
        source = json["source"].stringValue
        state = json["state"].stringValue
        store = json["store"] as AnyObject
        let tenantJson = json["tenant"]
        if !tenantJson.isEmpty{
            tenant = UCN(fromJson: tenantJson)
        }
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
        workNo = json["workNo"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if attachmentId != nil{
            dictionary["attachmentId"] = attachmentId
        }
        if attachments != nil{
            dictionary["attachments"] = attachments
        }
        if brokenTime != nil{
            dictionary["brokenTime"] = brokenTime
        }
        if cancleReason != nil{
            dictionary["cancleReason"] = cancleReason
        }
        if cancleTime != nil{
            dictionary["cancleTime"] = cancleTime
        }
        if cancleUser != nil{
            dictionary["cancleUser"] = cancleUser
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if descriptionField != nil{
            dictionary["description"] = descriptionField
        }
        if device != nil{
            dictionary["device"] = device.toDictionary()
        }
        if deviceType != nil{
            dictionary["deviceType"] = deviceType
        }
        if executes != nil{
            var dictionaryElements = [[String:Any]]()
            for executesElement in executes {
                dictionaryElements.append(executesElement.toDictionary())
            }
            dictionary["executes"] = dictionaryElements
        }
        if feedback != nil{
            dictionary["feedback"] = feedback
        }
        if feedbackNote != nil{
            dictionary["feedbackNote"] = feedbackNote
        }
        if finish != nil{
            dictionary["finish"] = finish
        }
        if finishNote != nil{
            dictionary["finishNote"] = finishNote
        }
        if finishTime != nil{
            dictionary["finishTime"] = finishTime
        }
        if finishUser != nil{
            dictionary["finishUser"] = finishUser
        }
        if labourfee != nil{
            dictionary["labourfee"] = labourfee
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if level != nil{
            dictionary["level"] = level
        }
        if materielfee != nil{
            dictionary["materielfee"] = materielfee
        }
        if note != nil{
            dictionary["note"] = note
        }
        if position != nil{
            dictionary["position"] = position.toDictionary()
        }
        if receiveTime != nil{
            dictionary["receiveTime"] = receiveTime
        }
        if reportOrg != nil{
            dictionary["reportOrg"] = reportOrg
        }
        if reportUser != nil{
            dictionary["reportUser"] = reportUser.toDictionary()
        }
        if reporterPhone != nil{
            dictionary["reporterPhone"] = reporterPhone
        }
        if requestTime != nil{
            dictionary["requestTime"] = requestTime
        }
        if serviceType != nil{
            dictionary["serviceType"] = serviceType
        }
        if source != nil{
            dictionary["source"] = source
        }
        if state != nil{
            dictionary["state"] = state
        }
        if store != nil{
            dictionary["store"] = store
        }
        if tenant != nil{
            dictionary["tenant"] = tenant.toDictionary()
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        if workNo != nil{
            dictionary["workNo"] = workNo
        }
        return dictionary
    }
}


class RepairOrderExecute : NSObject{
    
    var beginAttachmentId : String!
    var beginAttachments : AnyObject!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var dept : UCN!
    var endAttachmentId : String!
    var endAttachments : AnyObject!
    var executeMateriels : [AnyObject]!
    var executeNo : String!
    var executeOutsources : [AnyObject]!
    var hasOut : Bool!
    var hasPaid : Bool!
    var labourfee : AnyObject!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var materielfee : Int!
    var note : AnyObject!
    var owner : UCN!
    var ownerTime : String!
    var processBegin : AnyObject!
    var processEnd : AnyObject!
    var processMode : AnyObject!
    var processor : AnyObject!
    var property1 : AnyObject!
    var property2 : AnyObject!
    var reason : AnyObject!
    var state : String!
    var uuid : String!
    var version : Int!
    var workid : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        beginAttachmentId = json["beginAttachmentId"].stringValue
        beginAttachments = json["beginAttachments"] as AnyObject
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        let deptJson = json["dept"]
        if !deptJson.isEmpty{
            dept = UCN(fromJson: deptJson)
        }
        endAttachmentId = json["endAttachmentId"].stringValue
        endAttachments = json["endAttachments"] as AnyObject
        executeMateriels = [AnyObject]()
        let executeMaterielsArray = json["executeMateriels"].arrayValue
        for executeMaterielsJson in executeMaterielsArray{
            executeMateriels.append(executeMaterielsJson.stringValue as AnyObject)
        }
        executeNo = json["executeNo"].stringValue
        executeOutsources = [AnyObject]()
        let executeOutsourcesArray = json["executeOutsources"].arrayValue
        for executeOutsourcesJson in executeOutsourcesArray{
            executeOutsources.append(executeOutsourcesJson.stringValue as AnyObject)
        }
        hasOut = json["hasOut"].boolValue
        hasPaid = json["hasPaid"].boolValue
        labourfee = json["labourfee"].stringValue as AnyObject
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        materielfee = json["materielfee"].intValue
        note = json["note"].stringValue as AnyObject
        let ownerJson = json["owner"]
        if !ownerJson.isEmpty{
            owner = UCN(fromJson: ownerJson)
        }
        ownerTime = json["ownerTime"].stringValue
        processBegin = json["processBegin"].stringValue as AnyObject
        processEnd = json["processEnd"].stringValue as AnyObject
        processMode = json["processMode"].stringValue as AnyObject
        processor = json["processor"].stringValue as AnyObject
        property1 = json["property1"].stringValue as AnyObject
        property2 = json["property2"].stringValue as AnyObject
        reason = json["reason"].stringValue as AnyObject
        state = json["state"].stringValue
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
        workid = json["workid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if beginAttachmentId != nil{
            dictionary["beginAttachmentId"] = beginAttachmentId
        }
        if beginAttachments != nil{
            dictionary["beginAttachments"] = beginAttachments
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if dept != nil{
            dictionary["dept"] = dept.toDictionary()
        }
        if endAttachmentId != nil{
            dictionary["endAttachmentId"] = endAttachmentId
        }
        if endAttachments != nil{
            dictionary["endAttachments"] = endAttachments
        }
        if executeMateriels != nil{
            dictionary["executeMateriels"] = executeMateriels
        }
        if executeNo != nil{
            dictionary["executeNo"] = executeNo
        }
        if executeOutsources != nil{
            dictionary["executeOutsources"] = executeOutsources
        }
        if hasOut != nil{
            dictionary["hasOut"] = hasOut
        }
        if hasPaid != nil{
            dictionary["hasPaid"] = hasPaid
        }
        if labourfee != nil{
            dictionary["labourfee"] = labourfee
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if materielfee != nil{
            dictionary["materielfee"] = materielfee
        }
        if note != nil{
            dictionary["note"] = note
        }
        if owner != nil{
            dictionary["owner"] = owner.toDictionary()
        }
        if ownerTime != nil{
            dictionary["ownerTime"] = ownerTime
        }
        if processBegin != nil{
            dictionary["processBegin"] = processBegin
        }
        if processEnd != nil{
            dictionary["processEnd"] = processEnd
        }
        if processMode != nil{
            dictionary["processMode"] = processMode
        }
        if processor != nil{
            dictionary["processor"] = processor
        }
        if property1 != nil{
            dictionary["property1"] = property1
        }
        if property2 != nil{
            dictionary["property2"] = property2
        }
        if reason != nil{
            dictionary["reason"] = reason
        }
        if state != nil{
            dictionary["state"] = state
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        if workid != nil{
            dictionary["workid"] = workid
        }
        return dictionary
    }
}
