//
//	RepairOrderDetailResult.swift
//
//	Create by 云霄 曹 on 12/1/2018
//	Copyright © 2018. All rights reserved.

import Foundation
import SwiftyJSON


/// 工单详情
class RepairOrderDetailResult : NSObject{

	var data : BillDetailData!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		let dataJson = json["data"]
		if !dataJson.isEmpty{
			data = BillDetailData(fromJson: dataJson)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			dictionary["data"] = data.toDictionary()
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}


}

open class BillDetailData : NSObject{
    
    var attachmentId : String!
    var attachments : String!
    var brokenTime : String!
    var cancleReason : String!
    var cancleTime : String!
    var cancleUser : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var descriptionField : String!
    var descriptionFieldHeight: CGFloat! = 10
    var device : UCN!
    var deviceType : String!
    var deviceadree : String!
    var executes : [BillDetailExecute]!
    var feedback : String!
    var feedbackNote : String!
    var finish : Bool! = false
    var finishNote : String!
    var finishNoteHeight : CGFloat! = 10
    var finishTime : String!
    var locationAttachmentId: String!
    var finishUser : UCN!
    var labourfee : String!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var level : String!
    var materielfee : String!
    var note : String!
    var noteHeight: CGFloat! = 10
    var position : UCN!
    var receiveTime : String!
    var reportOrg : String!
    var reportUser : UCN!
    var reporterPhone : String!
    var requestTime : String!
    var serviceType : String!
    var source : String!
    var state : String!
    var store : UCN!
    var tenant : UCN!
    var uuid : String!
    var version : Int!
    var workNo : String!
    var isEditable: Bool! = false
    
    
    init(_ state: String) {
        self.state = state
    }
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        isEditable = json["isEditable"].boolValue
        attachmentId = json["attachmentId"].stringValue
        attachments = json["attachments"].stringValue
        brokenTime = json["brokenTime"].stringValue
        cancleReason = json["cancleReason"].stringValue
        cancleTime = json["cancleTime"].stringValue
        cancleUser = json["cancleUser"].stringValue
        createId = json["create_id"].stringValue
        locationAttachmentId = json["locationAttachmentId"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        descriptionField = json["description"].stringValue
        descriptionFieldHeight = descriptionField.calculateStringSize(CGSize(width: kWidth - 105, height: CGFloat.greatestFiniteMagnitude), font: UIFont.systemFont(ofSize: 13)).height        
        let deviceJson = json["device"]
        if !deviceJson.isEmpty{
            device = UCN(fromJson: deviceJson)
        }
        deviceType = json["deviceType"].stringValue
        deviceadree = json["deviceadree"].stringValue
        executes = [BillDetailExecute]()
        let executesArray = json["executes"].arrayValue
        for executesJson in executesArray{
            let value = BillDetailExecute(fromJson: executesJson)
            executes.append(value)
        }
        feedback = json["feedback"].stringValue
        feedbackNote = json["feedbackNote"].stringValue
        finish = json["finish"].boolValue
        finishNote = json["finishNote"].stringValue
        finishNoteHeight = finishNote.calculateStringSize(CGSize(width: kWidth - 105, height: CGFloat.greatestFiniteMagnitude), font: UIFont.systemFont(ofSize: 13)).height
        finishTime = json["finishTime"].stringValue
        let finishUserJson = json["finishUser"]
        if !finishUserJson.isEmpty{
            finishUser = UCN(fromJson: finishUserJson)
        }
        labourfee = json["labourfee"].stringValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        level = json["level"].stringValue
        materielfee = json["materielfee"].stringValue
        note = json["note"].stringValue
        noteHeight = note.calculateStringSize(CGSize(width: kWidth - 105, height: CGFloat.greatestFiniteMagnitude), font: UIFont.systemFont(ofSize: 13)).height

        let positionJson = json["position"]
        if !positionJson.isEmpty{
            position = UCN(fromJson: positionJson)
        }
        receiveTime = json["receiveTime"].stringValue
        reportOrg = json["reportOrg"].stringValue
        let reportUserJson = json["reportUser"]
        if !reportUserJson.isEmpty{
            reportUser = UCN(fromJson: reportUserJson)
        }
        reporterPhone = json["reporterPhone"].stringValue
        requestTime = json["requestTime"].stringValue
        serviceType = json["serviceType"].stringValue
        source = json["source"].stringValue
        state = json["state"].stringValue
        let storeJson = json["store"]
        if !storeJson.isEmpty{
            store = UCN(fromJson: storeJson)
        }
        let tenantJson = json["tenant"]
        if !tenantJson.isEmpty{
            tenant = UCN(fromJson: tenantJson)
        }
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
        workNo = json["workNo"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if attachmentId != nil{
            dictionary["attachmentId"] = attachmentId
        }
        if attachments != nil{
            dictionary["attachments"] = attachments
        }
        if brokenTime != nil{
            dictionary["brokenTime"] = brokenTime
        }
        if cancleReason != nil{
            dictionary["cancleReason"] = cancleReason
        }
        if cancleTime != nil{
            dictionary["cancleTime"] = cancleTime
        }
        if cancleUser != nil{
            dictionary["cancleUser"] = cancleUser
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if isEditable != nil{
            dictionary["isEditable"] = isEditable
        }
        if descriptionField != nil{
            dictionary["description"] = descriptionField
        }
        if locationAttachmentId != nil{
            dictionary["locationAttachmentId"] = locationAttachmentId
        }
        if device != nil{
            dictionary["device"] = device.toDictionary()
        }
        if deviceType != nil{
            dictionary["deviceType"] = deviceType
        }
        if deviceadree != nil{
            dictionary["deviceadree"] = deviceadree
        }
        if executes != nil{
            var dictionaryElements = [[String:Any]]()
            for executesElement in executes {
                dictionaryElements.append(executesElement.toDictionary())
            }
            dictionary["executes"] = dictionaryElements
        }
        if feedback != nil{
            dictionary["feedback"] = feedback
        }
        if feedbackNote != nil{
            dictionary["feedbackNote"] = feedbackNote
        }
        if finish != nil{
            dictionary["finish"] = finish
        }
        if finishNote != nil{
            dictionary["finishNote"] = finishNote
        }
        if finishTime != nil{
            dictionary["finishTime"] = finishTime
        }
        if finishUser != nil{
            dictionary["finishUser"] = finishUser.toDictionary()
        }
        if labourfee != nil{
            dictionary["labourfee"] = labourfee
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if level != nil{
            dictionary["level"] = level
        }
        if materielfee != nil{
            dictionary["materielfee"] = materielfee
        }
        if note != nil{
            dictionary["note"] = note
        }
        if position != nil{
            dictionary["position"] = position.toDictionary()
        }
        if receiveTime != nil{
            dictionary["receiveTime"] = receiveTime
        }
        if reportOrg != nil{
            dictionary["reportOrg"] = reportOrg
        }
        if reportUser != nil{
            dictionary["reportUser"] = reportUser.toDictionary()
        }
        if reporterPhone != nil{
            dictionary["reporterPhone"] = reporterPhone
        }
        if requestTime != nil{
            dictionary["requestTime"] = requestTime
        }
        if serviceType != nil{
            dictionary["serviceType"] = serviceType
        }
        if source != nil{
            dictionary["source"] = source
        }
        if state != nil{
            dictionary["state"] = state
        }
        if store != nil{
            dictionary["store"] = store.toDictionary()
        }
        if tenant != nil{
            dictionary["tenant"] = tenant.toDictionary()
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        if workNo != nil{
            dictionary["workNo"] = workNo
        }
        return dictionary
    }
    

}


open class BillDetailExecute : NSObject{
    
    var beginAttachmentId : String!
    var beginAttachments : AnyObject!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var dept : UCN!
    var endAttachmentId : String!
    var endAttachments : AnyObject!
    var executeMateriels : [AnyObject]!
    var executeNo : String!
    var executeOutsources : [AnyObject]!
    var hasOut : Bool!
    var hasPaid : Bool!
    var labourfee : Int!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var materielfee : Int!
    var note : String!
    var owner : UCN!
    var ownerTime : String!
    var processBegin : String!
    var processEnd : String!
    var processMode : String!
    var processor : String!
    var property1 : String!
    var property2 : String!
    var reason : String!
    var state : String!
    var uuid : String!
    var version : Int!
    var workid : String!
    var isEditable: Bool! = false
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        isEditable = json["isEditable"].boolValue
        beginAttachmentId = json["beginAttachmentId"].stringValue
        beginAttachments = json["beginAttachments"] as AnyObject
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        let deptJson = json["dept"]
        if !deptJson.isEmpty{
            dept = UCN(fromJson: deptJson)
        }
        endAttachmentId = json["endAttachmentId"].stringValue
        endAttachments = json["endAttachments"] as AnyObject
        executeMateriels = [AnyObject]()
        let executeMaterielsArray = json["executeMateriels"].arrayValue
        for executeMaterielsJson in executeMaterielsArray{
            executeMateriels.append(executeMaterielsJson as AnyObject)
        }
        executeNo = json["executeNo"].stringValue
        executeOutsources = [AnyObject]()
        let executeOutsourcesArray = json["executeOutsources"].arrayValue
        for executeOutsourcesJson in executeOutsourcesArray{
            executeOutsources.append(executeOutsourcesJson as AnyObject)
        }
        hasOut = json["hasOut"].boolValue
        hasPaid = json["hasPaid"].boolValue
        labourfee = json["labourfee"].intValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        materielfee = json["materielfee"].intValue
        note = json["note"].stringValue
        let ownerJson = json["owner"]
        if !ownerJson.isEmpty{
            owner = UCN(fromJson: ownerJson)
        }
        ownerTime = json["ownerTime"].stringValue
        processBegin = json["processBegin"].stringValue
        processEnd = json["processEnd"].stringValue
        processMode = json["processMode"].stringValue
        processor = json["processor"].stringValue
        property1 = json["property1"].stringValue
        property2 = json["property2"].stringValue
        reason = json["reason"].stringValue
        state = json["state"].stringValue
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
        workid = json["workid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if beginAttachmentId != nil{
            dictionary["beginAttachmentId"] = beginAttachmentId
        }
        if beginAttachments != nil{
            dictionary["beginAttachments"] = beginAttachments
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if dept != nil{
            dictionary["dept"] = dept.toDictionary()
        }
        if endAttachmentId != nil{
            dictionary["endAttachmentId"] = endAttachmentId
        }
        if isEditable != nil{
            dictionary["isEditable"] = isEditable
        }
        if endAttachments != nil{
            dictionary["endAttachments"] = endAttachments
        }
        if executeMateriels != nil{
            dictionary["executeMateriels"] = executeMateriels
        }
        if executeNo != nil{
            dictionary["executeNo"] = executeNo
        }
        if executeOutsources != nil{
            dictionary["executeOutsources"] = executeOutsources
        }
        if hasOut != nil{
            dictionary["hasOut"] = hasOut
        }
        if hasPaid != nil{
            dictionary["hasPaid"] = hasPaid
        }
        if labourfee != nil{
            dictionary["labourfee"] = labourfee
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if materielfee != nil{
            dictionary["materielfee"] = materielfee
        }
        if note != nil{
            dictionary["note"] = note
        }
        if owner != nil{
            dictionary["owner"] = owner.toDictionary()
        }
        if ownerTime != nil{
            dictionary["ownerTime"] = ownerTime
        }
        if processBegin != nil{
            dictionary["processBegin"] = processBegin
        }
        if processEnd != nil{
            dictionary["processEnd"] = processEnd
        }
        if processMode != nil{
            dictionary["processMode"] = processMode
        }
        if processor != nil{
            dictionary["processor"] = processor
        }
        if property1 != nil{
            dictionary["property1"] = property1
        }
        if property2 != nil{
            dictionary["property2"] = property2
        }
        if reason != nil{
            dictionary["reason"] = reason
        }
        if state != nil{
            dictionary["state"] = state
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        if workid != nil{
            dictionary["workid"] = workid
        }
        return dictionary
    }
    
}

