//
//	DepartmentResultModel.swift
//
//	Create by 云霄 曹 on 12/1/2018
//	Copyright © 2018. All rights reserved.
//	Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation 
import SwiftyJSON


class DepartmentResultModel : NSObject{

	var data : DepartmentData!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		let dataJson = json["data"]
		if !dataJson.isEmpty{
			data = DepartmentData(fromJson: dataJson)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			dictionary["data"] = data.toDictionary()
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}
}

class DepartmentData : NSObject{
    
    var paging : Paging!
    var records : [UCN]!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        let pagingJson = json["paging"]
        if !pagingJson.isEmpty{
            paging = Paging(fromJson: pagingJson)
        }
        records = [UCN]()
        let recordsArray = json["records"].arrayValue
        for recordsJson in recordsArray{
            let value = UCN(fromJson: recordsJson)
            records.append(value)
        }
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if paging != nil{
            dictionary["paging"] = paging.toDictionary()
        }
        if records != nil{
            var dictionaryElements = [[String:Any]]()
            for recordsElement in records {
                dictionaryElements.append(recordsElement.toDictionary())
            }
            dictionary["records"] = dictionaryElements
        }
        return dictionary
    }
    
}
