//
//	BillCompletedRequestModel.swift
//
//	Create by 云霄 曹 on 15/1/2018
//	Copyright © 2018. All rights reserved.

import Foundation 
import SwiftyJSON


open class BillCompletedRequestModel : NSObject{

    var attachmentId : String!
    var brokenTime : String!
    var descriptionField : String!
    var descriptionFieldHeight: CGFloat! = 10
    var device : UCN!
    var deviceadree : String!
    var finish : Bool! = false
    var finishNote : String!
    var finishNoteHeight : CGFloat! = 10
    var finishTime : String!
    var locationAttachmentId: String!
    var finishUser : UCN!
    var level : String!
    var note : String!
    var noteHeight: CGFloat! = 10
    var position : UCN!
    var receiveTime : String!
    var reportUser : UCN!
    var reporterPhone : String!
    var requestTime : String!
    var serviceType : String!
    var source : String!
    var state : String!
    var store : UCN!
    var tenant : UCN!
    var uuid : String!
    var version : Int!
    var workNo : String!
    
    
    init(_ state: String) {
        self.state = state
    }
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        attachmentId = json["attachmentId"].stringValue
        brokenTime = json["brokenTime"].stringValue
        locationAttachmentId = json["locationAttachmentId"].stringValue
        descriptionField = json["description"].stringValue
        descriptionFieldHeight = descriptionField.calculateStringSize(CGSize(width: kWidth - 105, height: CGFloat.greatestFiniteMagnitude), font: UIFont.systemFont(ofSize: 13)).height
        let deviceJson = json["device"]
        if !deviceJson.isEmpty{
            device = UCN(fromJson: deviceJson)
        }
        deviceadree = json["deviceadree"].stringValue
        finish = json["finish"].boolValue
        finishNote = json["finishNote"].stringValue
        finishNoteHeight = finishNote.calculateStringSize(CGSize(width: kWidth - 105, height: CGFloat.greatestFiniteMagnitude), font: UIFont.systemFont(ofSize: 13)).height
        finishTime = json["finishTime"].stringValue
        let finishUserJson = json["finishUser"]
        if !finishUserJson.isEmpty{
            finishUser = UCN(fromJson: finishUserJson)
        }
        level = json["level"].stringValue
        note = json["note"].stringValue
        noteHeight = note.calculateStringSize(CGSize(width: kWidth - 105, height: CGFloat.greatestFiniteMagnitude), font: UIFont.systemFont(ofSize: 13)).height
        
        let positionJson = json["position"]
        if !positionJson.isEmpty{
            position = UCN(fromJson: positionJson)
        }
        receiveTime = json["receiveTime"].stringValue
        let reportUserJson = json["reportUser"]
        if !reportUserJson.isEmpty{
            reportUser = UCN(fromJson: reportUserJson)
        }
        reporterPhone = json["reporterPhone"].stringValue
        requestTime = json["requestTime"].stringValue
        serviceType = json["serviceType"].stringValue
        source = json["source"].stringValue
        state = json["state"].stringValue
        let storeJson = json["store"]
        if !storeJson.isEmpty{
            store = UCN(fromJson: storeJson)
        }
        let tenantJson = json["tenant"]
        if !tenantJson.isEmpty{
            tenant = UCN(fromJson: tenantJson)
        }
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
        workNo = json["workNo"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if attachmentId != nil{
            dictionary["attachmentId"] = attachmentId
        }
        if brokenTime != nil{
            dictionary["brokenTime"] = brokenTime
        }
        if descriptionField != nil{
            dictionary["description"] = descriptionField
        }
        if locationAttachmentId != nil{
            dictionary["locationAttachmentId"] = locationAttachmentId
        }
        if device != nil{
            dictionary["device"] = device.toDictionary()
        }
        if deviceadree != nil{
            dictionary["deviceadree"] = deviceadree
        }
        if finish != nil{
            dictionary["finish"] = finish
        }
        if finishNote != nil{
            dictionary["finishNote"] = finishNote
        }
        if finishTime != nil{
            dictionary["finishTime"] = finishTime
        }
        if finishUser != nil{
            dictionary["finishUser"] = finishUser.toDictionary()
        }
        if level != nil{
            dictionary["level"] = level
        }
        if note != nil{
            dictionary["note"] = note
        }
        if position != nil{
            dictionary["position"] = position.toDictionary()
        }
        if receiveTime != nil{
            dictionary["receiveTime"] = receiveTime
        }
        if reportUser != nil{
            dictionary["reportUser"] = reportUser.toDictionary()
        }
        if reporterPhone != nil{
            dictionary["reporterPhone"] = reporterPhone
        }
        if requestTime != nil{
            dictionary["requestTime"] = requestTime
        }
        if serviceType != nil{
            dictionary["serviceType"] = serviceType
        }
        if source != nil{
            dictionary["source"] = source
        }
        if state != nil{
            dictionary["state"] = state
        }
        if store != nil{
            dictionary["store"] = store.toDictionary()
        }
        if tenant != nil{
            dictionary["tenant"] = tenant.toDictionary()
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        if workNo != nil{
            dictionary["workNo"] = workNo
        }
        return dictionary
    }
}
