//
//	RootClass.swift
//
//	Create by 云霄 曹 on 15/1/2018
//	Copyright © 2018. All rights reserved.

import Foundation 
import SwiftyJSON


class AttachmentResultModel : NSObject{

	var data : [AttachmentData]!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		data = [AttachmentData]()
		let dataArray = json["data"].arrayValue
		for dataJson in dataArray{
			let value = AttachmentData(fromJson: dataJson)
			data.append(value)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			var dictionaryElements = [[String:Any]]()
			for dataElement in data {
				dictionaryElements.append(dataElement.toDictionary())
			}
			dictionary["data"] = dictionaryElements
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}

}


class AttachmentData : NSObject{
    
    var entityType : String!
    var entityUuid : String!
    var fileName : String!
    var fileUrl : String!
    var lastModified : String!
    var thumbnailFileName : String!
    var uuid : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        entityType = json["entityType"].stringValue
        entityUuid = json["entityUuid"].stringValue
        fileName = json["fileName"].stringValue
        fileUrl = json["fileUrl"].stringValue
        lastModified = json["lastModified"].stringValue
        thumbnailFileName = json["thumbnailFileName"].stringValue
        uuid = json["uuid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if entityType != nil{
            dictionary["entityType"] = entityType
        }
        if entityUuid != nil{
            dictionary["entityUuid"] = entityUuid
        }
        if fileName != nil{
            dictionary["fileName"] = fileName
        }
        if fileUrl != nil{
            dictionary["fileUrl"] = fileUrl
        }
        if lastModified != nil{
            dictionary["lastModified"] = lastModified
        }
        if thumbnailFileName != nil{
            dictionary["thumbnailFileName"] = thumbnailFileName
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        return dictionary
    }
}
