//
//  RepairOrderViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/3.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxCocoa
import RxSwift

class RepairOrderViewController: BaseTableViewPullController {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 新建工单
    @IBOutlet weak var addOrderButton: UIButton!
    /// 日期选择
    @IBOutlet weak var dateChooseButton: UIButton!
    /// 状态选择
    @IBOutlet weak var stateChooseButton: UIButton!
    /// 来源选择
    @IBOutlet weak var sourceChooseButton: UIButton!
    /// 优先级选择
    @IBOutlet weak var priorityChooseButton: UIButton!
    
    /// 工单列表ViewModel
    lazy final var repairOrderViewModel: RepairOrderViewModel = {
        var repairOrderViewModel = RepairOrderViewModel()
        return repairOrderViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        bindingRxAction()
        noticeRefreshDataAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        title = "工单列表"
        dateChooseButton.addBorder(1.0, kGaryColor)
        stateChooseButton.addBorder(1.0, kGaryColor)
        sourceChooseButton.addBorder(1.0, kGaryColor)
        priorityChooseButton.addBorder(1.0, kGaryColor)
        dateChooseButton.horizontalCenterTitleAndImage(5)
        dateChooseButton.titleLabel?.adjustsFontSizeToFitWidth = true
        stateChooseButton.horizontalCenterTitleAndImage(5)
        stateChooseButton.titleLabel?.adjustsFontSizeToFitWidth = true
        sourceChooseButton.horizontalCenterTitleAndImage(5)
        sourceChooseButton.titleLabel?.adjustsFontSizeToFitWidth = true
        priorityChooseButton.horizontalCenterTitleAndImage(5)
        priorityChooseButton.titleLabel?.adjustsFontSizeToFitWidth = true
        addOrderButton.isHidden = !PermissionsManager.createBillPermissions()
    }
    
    // MARK: - 绑定RxSwift事件
    fileprivate func bindingRxAction() {
        dateChooseButton.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.dateChooseButton.isSelected = true
            self?.dateChooseButton.addBorder(1.0, kBlueColor)
            self?.repairOrderViewModel.repairOrderFilterBtnAction((self?.dateChooseButton)!).subscribe(onNext: { () in
                self?.tableView.mj_header.beginRefreshing()
            }).disposed(by: (self?.disposeBag)!)
        }).disposed(by: disposeBag)
        
        stateChooseButton.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.stateChooseButton.isSelected = true
            self?.stateChooseButton.addBorder(1.0, kBlueColor)
            self?.repairOrderViewModel.repairOrderFilterBtnAction((self?.stateChooseButton)!).subscribe(onNext: { () in
                self?.tableView.mj_header.beginRefreshing()
            }).disposed(by: (self?.disposeBag)!)
        }).disposed(by: disposeBag)
        
        sourceChooseButton.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.sourceChooseButton.isSelected = true
            self?.sourceChooseButton.addBorder(1.0, kBlueColor)
            self?.repairOrderViewModel.repairOrderFilterBtnAction((self?.sourceChooseButton)!).subscribe(onNext: { () in
                self?.tableView.mj_header.beginRefreshing()
            }).disposed(by: (self?.disposeBag)!)
        }).disposed(by: disposeBag)
        
        priorityChooseButton.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.priorityChooseButton.isSelected = true
            self?.priorityChooseButton.addBorder(1.0, kBlueColor)
            self?.repairOrderViewModel.repairOrderFilterBtnAction((self?.priorityChooseButton)!).subscribe(onNext: { () in
                self?.tableView.mj_header.beginRefreshing()
            }).disposed(by: (self?.disposeBag)!)
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 通知刷新数据
    func noticeRefreshDataAction() {
        NotificationCenter.default.rx.notification(Notification.Name(rawValue: UPDATE_BILL_LIST)).subscribe(onNext: {[weak self] (notice) in
            self?.pullPageIndex = kZERO
            self?.repairOrderViewModel.queryModel.endCreateTime = NSDate().httpParameterString()
            self?.loadWebDataSource()
        }).disposed(by: disposeBag)
    }

    // MARK: - 加载数据
    override func loadWebDataSource() {
        repairOrderViewModel.queryModel.page = pullPageIndex
        repairOrderViewModel.queryRepairOrderAction().subscribe {[weak self] (event) in
            switch event {
            case .next(let page):
                if (self?.pullPageIndex)! >= page - kONE {
                    self?.endRefreshNomoreData()
                }else {
                    self?.endRefresh()
                }
                break
            case .error(_):
                self?.endRefreshNomoreData()
                break
            default:
                break
            }
            self?.reloadData()
        }.disposed(by: disposeBag)
    }

    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        return repairOrderViewModel.dequeueReusableCell(RepairOrderTableViewCell.name(),tableView,indexPath)
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return repairOrderViewModel.repairOrderArray.count
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 135
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        self.performSegue(withIdentifier: RepairOrderDetailBgController.name(), sender: indexPath)
    }
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == RepairOrderDetailBgController.name()  {
            let detailBgVc = segue.destination as! RepairOrderDetailBgController
            let indexPath = sender as! IndexPath
            detailBgVc.billModel = repairOrderViewModel.repairOrderArray[indexPath.row]
        }
    }
}














