//
//  RepairOrderDetailViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/8.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxCocoa
import RxSwift
import SwiftyJSON


class RepairOrderDetailViewController: BaseTableViewController {

    /// 已发出状态
    @IBOutlet weak var createdStateImg: UIImageView!
    @IBOutlet weak var createStateLab: UILabel!
    /// 处理中状态
    @IBOutlet weak var processedStateImg: UIImageView!
    @IBOutlet weak var processedStateLab: UILabel!
    /// 已完成状态
    @IBOutlet weak var completedStateImg: UIImageView!
    @IBOutlet weak var completedStateLab: UILabel!
    /// 单号
    @IBOutlet weak var billNumberLab: UILabel!
    /// 项目
    @IBOutlet weak var projectLabel: UILabel!
    /// 来源
    @IBOutlet weak var sourceLab: UILabel!
    /// 服务类型
    @IBOutlet weak var serverTypeLab: UILabel!
    /// 优先级
    @IBOutlet weak var priorityLab: UILabel!
    /// 报事人
    @IBOutlet weak var userLab: UILabel!
    /// 联系电话
    @IBOutlet weak var phoneLab: UILabel!
    /// 接报时间
    @IBOutlet weak var createTimeLab: UILabel!
    /// 指定时间
    @IBOutlet weak var requestTimeLab: UILabel!
    /// 位置
    @IBOutlet weak var positionLabel: UILabel!
    /// 设施
    @IBOutlet weak var deviceLab: UILabel!
    /// 设施位置
    @IBOutlet weak var deviceLocationLab: UILabel!
    /// 故障时间
    @IBOutlet weak var brokenTimeLab: UILabel!
    /// 描述
    @IBOutlet weak var descriptionLab: UILabel!
    /// 是否解决
    @IBOutlet weak var isSolveLabel: UILabel!
    /// 完成情况
    @IBOutlet weak var completionLabel: UILabel!
    /// 备注
    @IBOutlet weak var remarkLabel: UILabel!
    
    /// 附件宽度
    let imageWidth = ((kWidth - 90) - CGFloat((3 + kONE) * 5)) / 3
    /// 工单状态回调
    var stateBlock: BillStateBlock!
    /// 悬浮框透明度回调
    var suspendViewAlphaBlock: SuspendViewAlphaBlock!
    /// 悬浮框状态回调
    var suspendViewStateBlock: SuspendViewStateBlock!
    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 工单详情ViewModel
    lazy final var orderDetailViewModel: RepairOrderDetailViewModel = {
        var orderDetailViewModel = RepairOrderDetailViewModel()
        return orderDetailViewModel
    }()
    /// 子工单详情ViewModel
    lazy final var childBillViewModel: ReparirChildBillViewModel = {
        var childBillViewModel = ReparirChildBillViewModel()
        return childBillViewModel
    }()
    /// 工单数据
    open var billModel: RepairOrderRecord!
    /// 图片附件高度
    var attachmentHeight: CGFloat! = 20
    /// 位置图片附件高度
    var locationAttHeight: CGFloat! = 20
    /// 子工单高度
    let childBillCellHeight: CGFloat! = 70
    /// 附件每行显示个数
    let attachmentCount: Int = 3
    /// 照片描述图片附件
    lazy final var attachmentVc: PhotoAttachmentViewController = {
        var attachmentVc = PhotoAttachmentViewController.instantiateViewController(.Function) as! PhotoAttachmentViewController
        return attachmentVc
    }()
    
    /// 位置图图片附件
    lazy final var locationAttVc: PhotoAttachmentViewController = {
        var locationAttVc = PhotoAttachmentViewController.instantiateViewController(.Function) as! PhotoAttachmentViewController
        return locationAttVc
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        setupTableView()
        getBillDetailAction()
        noticeRefreshDataAction()
    }
    
    // MARK: - 设置TableView
    fileprivate func setupTableView() {
        tableView.register(UINib(nibName: RepairOrderDetailSectionView.name(), bundle: nil), forHeaderFooterViewReuseIdentifier: RepairOrderDetailSectionView.name())
        tableView.register(UINib(nibName: RepairOrderAttachmentTableViewCell.name(), bundle: nil), forCellReuseIdentifier: RepairOrderAttachmentTableViewCell.name())
        tableView.register(UINib(nibName: RepairOrderSubOrderTableViewCell.name(), bundle: nil), forCellReuseIdentifier: RepairOrderSubOrderTableViewCell.name())
        addChildViewController(attachmentVc)
        orderDetailViewModel.billDetailModel = BillDetailData(billModel.state)
    }
    
    // MARK: - 获取tableView显示内容高度
    fileprivate func getTableViewHeight() ->CGFloat {
        view.layoutIfNeeded()
        return tableView.contentSize.height
    }
    
    // MARK: - 前往子工单完成界面
    fileprivate func gotoEditingSonOrderVc(_ indexPath: IndexPath) {
        self.performSegue(withIdentifier: RepairOrderEditSonOrderViewController.name(), sender: indexPath)
    }
    
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        if segue.identifier == RepairOrderEditSonOrderViewController.name() {
            let childBillVc = segue.destination as! RepairOrderEditSonOrderViewController
            let indexPath = sender as! IndexPath
            childBillVc.billModel = orderDetailViewModel.billDetailModel.executes[indexPath.row]
        }else if segue.identifier == RepairOrderChildBillDetailViewController.name() {
            let childBillDetailVc = segue.destination as! RepairOrderChildBillDetailViewController
            let indexPath = sender as! IndexPath
            childBillDetailVc.billModel = orderDetailViewModel.billDetailModel.executes[indexPath.row]
        }
    }
    
    // MARK: - 获取工单详情
    fileprivate func getBillDetailAction() {
        orderDetailViewModel.queryRepairOrderDetailAction(billModel.uuid).subscribe {[weak self] (event) in
            self?.orderDetailViewModel.billDetailAssignment(self!)
            self?.orderDetailViewModel.billDetailStataDispose(self!)
            self?.stateBlock((self?.orderDetailViewModel.billDetailModel.state)!)
            self?.disposeAttachment()
            self?.suspendViewStateAction()
            self?.tableView.reloadData()
        }.disposed(by: disposeBag)
    }

    // MARK: - 悬浮框状态判断
    fileprivate func suspendViewStateAction() {
        for i in 0..<orderDetailViewModel.billDetailModel.executes.count {
            let model = orderDetailViewModel.billDetailModel.executes[i]
            if model.isEditable == true
                && (model.state == SUBMIT_REPAIR_ORDER_STATE.INIT.rawValue || model.state == SUBMIT_REPAIR_ORDER_STATE.DREW.rawValue)
                && orderDetailViewModel.billDetailModel.state != SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue
                && orderDetailViewModel.billDetailModel.state != SUBMIT_REPAIR_ORDER_STATE.CANCLED.rawValue
                && orderDetailViewModel.billDetailModel.state != SUBMIT_REPAIR_ORDER_STATE.DELETED.rawValue {
                self.suspendViewStateBlock(model,IndexPath(row: i, section: REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue),model.state)
                break
            }
            if i == orderDetailViewModel.billDetailModel.executes.count - kONE {
                self.suspendViewStateBlock(model,IndexPath(row: i, section: REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue),SUBMIT_REPAIR_ORDER_STATE.DONE.rawValue)
            }
        }
    }
    
    // MARK: - 悬浮框按钮点击
    func suspendViewButtonClickAction(_ title: String, _ model: BillDetailExecute, _ indexPath: IndexPath) {
        if title == SUSPEND_BUTTON_TYPE.GET.rawValue {
            if !PermissionsManager.drawChildPermissions() && model.isEditable {
                ShowMessage("当前用户对此工单没有领取权限!")
                return;
            }
            ShowAlertView(hint, "请确认是否领取此部门工单?", [cancel,sure], .alert, {[weak self] (index) in
                if index == kZERO { return }
                self?.orderDetailViewModel.getChildBillAction(model.uuid).subscribe(onNext: { () in
                    self?.getBillDetailAction()
                    self?.gotoEditingSonOrderVc(indexPath)
                    ShowMessage("领取成功")
                }).disposed(by: self!.disposeBag)
            })
        }else {
            if !PermissionsManager.finishChildPermissions() && model.isEditable {
                ShowMessage("当前用户对此工单没有完成权限!")
                return;
            }
            ShowAlertView(hint, "请确认是否完成此部门工单?", [cancel,sure], .alert, {[weak self] (index) in
                if index == kZERO { return }
                self?.childBillViewModel.childBillDetailData = ChildBillDetailData(fromJson: JSON(model.toDictionary()))
                self?.childBillViewModel.finishChildBillAction().subscribe(onNext: { () in
                    self?.getBillDetailAction()
                    ShowMessage("子工单完成")
                }).disposed(by:self!.disposeBag)
            })
        }
    }

    // MARK: - 获取图片附件通过entity uuid
    fileprivate func disposeAttachment() {
        //获取照片描述附件
        orderDetailViewModel.downloadAttachmentAction(ATTACHMENT_TYPE.BILL_ATTACHMENT_TYPE.rawValue).subscribe(onNext: {[weak self] (attachments) in
                self?.attachmentVc.attachmentViewModel.photoAttachments.removeAll()
                for model in attachments {
                    let url = String(format: attachmentUrl, model.entityType,model.entityUuid,model.fileName)
                  self?.attachmentVc.attachmentViewModel.photoAttachments.append(PhotoAttachmentModel(url, ATTACHMENT_TYPE.BILL_ATTACHMENT_TYPE.rawValue, model.entityUuid, ATTACHMENT_LOCATION.ATTACHMENT_HTTP))
                }
            self?.attachmentVc.setItemSize(CGSize(width: self!.imageWidth, height: self!.imageWidth),self!.attachmentCount)
            let attHeight = self?.attachmentVc.attachmentHeight(attachments.count,nil)
            self?.attachmentHeight = attHeight
            self?.tableView.reloadData()
            }).disposed(by: disposeBag)
        
        //获取位置图附件
        orderDetailViewModel.downloadLocationAttAction(ATTACHMENT_TYPE.BILL_ATTACHMENT_TYPE.rawValue).subscribe(onNext: {[weak self] (attachments) in
            self?.locationAttVc.attachmentViewModel.photoAttachments.removeAll()
            let model = attachments.first
            if let model = model {
                let url = String(format: attachmentUrl, model.entityType,model.entityUuid,model.fileName)
                self?.locationAttVc.attachmentViewModel.photoAttachments.append(PhotoAttachmentModel(url, ATTACHMENT_TYPE.BILL_ATTACHMENT_TYPE.rawValue, model.entityUuid, ATTACHMENT_LOCATION.ATTACHMENT_HTTP))
                self?.locationAttVc.setItemSize(CGSize(width: self!.imageWidth, height: self!.imageWidth),self!.attachmentCount)
                let attHeight = self?.locationAttVc.attachmentHeight(kONE,nil)
                self?.locationAttHeight = attHeight
            }
            self?.tableView.reloadData()
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 工单状态回调
    func setStateBlock(_ block: @escaping BillStateBlock) {
        self.stateBlock = block
    }
    
    // MARK: - 悬浮框透明度回调
    func setSuspendViewAlphaBlock(_ block: @escaping SuspendViewAlphaBlock) {
        self.suspendViewAlphaBlock = block
    }
    
    // MARK: - 悬浮框状态回调
    func setSuspendViewStateBlock(_ block: @escaping SuspendViewStateBlock) {
        self.suspendViewStateBlock = block
    }
    
    // MARK: - 转交工单...查询、选择部门
    func transferRepairOrder() {
        let model = QueryModel()
        model.storeUuidEquals = orderDetailViewModel.billDetailModel.store.uuid
        orderDetailViewModel.queryRepairOrderDepartmentAction(model).subscribe(onNext: {[weak self] (resuleModel) in
            self?.orderDetailViewModel.repairOrderDepartmentChoice(resuleModel, self!).subscribe(onNext: { (result) in
                ShowAlertView(hint, result.0, [cancel,sure], .alert, { (index) in
                    if index == kZERO { return }
                    self?.transferRepairOrderAction(result.1)
                })
            }).disposed(by: self!.disposeBag)
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 转交工单请求
    fileprivate func transferRepairOrderAction(_ array: Array<String>) {
        let model = DepartmentQueryModel()
        model.deptUuids = array
        model.workUuid = orderDetailViewModel.billDetailModel.uuid
        orderDetailViewModel.transferRepairOrderAction(model).subscribe(onNext: {[weak self] () in
            self?.getBillDetailAction()
            NotificationCenter.default.post(Notification(name: Notification.Name(rawValue: UPDATE_BILL_LIST)))
            ShowMessage("转交成功")
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 通知刷新数据
    func noticeRefreshDataAction() {
        NotificationCenter.default.rx.notification(Notification.Name(rawValue: UPDATE_BILL_DETAIL_LIST)).subscribe(onNext: {[weak self] (notice) in
            self?.getBillDetailAction()
        }).disposed(by: disposeBag)
    }
}

extension RepairOrderDetailViewController {
    
    // MARK: - UITableViewDelegate,UITableViewDataSource
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue {
            return orderDetailViewModel.dequeueChildBillReusableCell(RepairOrderSubOrderTableViewCell.name(), indexPath, tableView)
        }
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SOURCE.rawValue && indexPath.row == 9 {
            let attachmentCell = tableView.dequeueReusableCell(withIdentifier: RepairOrderAttachmentTableViewCell.name(), for: indexPath) as! RepairOrderAttachmentTableViewCell
            attachmentCell.titleLabel.text = "位置图"
            locationAttVc.view.frame = CGRect(x: 80, y: 5, width: kWidth - 90, height: locationAttHeight)
            attachmentCell.contentView.addSubview(locationAttVc.view)
            return attachmentCell
        }
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SOURCE.rawValue && indexPath.row == 14 {
            let attachmentCell = tableView.dequeueReusableCell(withIdentifier: RepairOrderAttachmentTableViewCell.name(), for: indexPath) as! RepairOrderAttachmentTableViewCell
            attachmentCell.titleLabel.text = "照片描述"
            attachmentVc.view.frame = CGRect(x: 80, y: 5, width: kWidth - 90, height: attachmentHeight)
            attachmentCell.contentView.addSubview(attachmentVc.view)
            return attachmentCell
        }
        return super.tableView(tableView, cellForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue {
            guard orderDetailViewModel.billDetailModel != nil else {
                return kZERO
            }
            guard orderDetailViewModel.billDetailModel.executes != nil else {
                return kZERO
            }
            return orderDetailViewModel.billDetailModel.executes.count
        }
        return super.tableView(tableView, numberOfRowsInSection: section)
    }
    
    override func numberOfSections(in tableView: UITableView) -> Int {
        guard orderDetailViewModel.billDetailModel != nil else {
            return super.numberOfSections(in: tableView)
        }
        switch orderDetailViewModel.billDetailModel.state {
        case SUBMIT_REPAIR_ORDER_STATE.CREATED.rawValue:
            return 2
        case SUBMIT_REPAIR_ORDER_STATE.SUBMIT.rawValue:
            return 2
        case SUBMIT_REPAIR_ORDER_STATE.PROCESSING.rawValue:
            return 3
        case SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue:
            return super.numberOfSections(in: tableView)
        default:
            break
        }
        return super.numberOfSections(in: tableView)
    }
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue {
            if indexPath.row == orderDetailViewModel.billDetailModel.executes.count - kONE {
                return childBillCellHeight + 10
            }
            return childBillCellHeight
        }
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SOURCE.rawValue && indexPath.row == 9 {
            return locationAttHeight + 20
        }
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SOURCE.rawValue && indexPath.row == 13 {
            return orderDetailViewModel.billDetailModel.descriptionFieldHeight + 20
        }
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SOURCE.rawValue && indexPath.row == 14 {
            return attachmentHeight + 20
        }
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SOURCE.rawValue && indexPath.row == 15 {
            return orderDetailViewModel.billDetailModel.noteHeight + 20
        }
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.COMPLETED.rawValue && indexPath.row == 1 {
            return orderDetailViewModel.billDetailModel.finishNoteHeight + 20
        }
        return super.tableView(tableView, heightForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue {
            let model = orderDetailViewModel.billDetailModel.executes[indexPath.row]
            switch model.state {
            case SUBMIT_REPAIR_ORDER_STATE.INIT.rawValue:
                if orderDetailViewModel.billDetailModel.state == SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue {
                    self.performSegue(withIdentifier: RepairOrderChildBillDetailViewController.name(), sender: indexPath)
                    return
                }
                if !PermissionsManager.drawChildPermissions() || !model.isEditable {
                    ShowMessage("当前用户对此工单没有领取权限!")
                    return
                }
                ShowAlertView(hint, "请确认是否领单?", [cancel,sure], .alert, {[weak self] (index) in
                    if index == kZERO { return }
                    self?.orderDetailViewModel.getChildBillAction(model.uuid).subscribe(onNext: { () in
                        self?.getBillDetailAction()
                        if model.isEditable {
                            self?.gotoEditingSonOrderVc(indexPath)
                        }
                        ShowMessage("领取成功")
                    }).disposed(by: self!.disposeBag)
                })
                break
            case SUBMIT_REPAIR_ORDER_STATE.DREW.rawValue:
                if orderDetailViewModel.billDetailModel.state == SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue || orderDetailViewModel.billDetailModel.state == SUBMIT_REPAIR_ORDER_STATE.CANCLED.rawValue || orderDetailViewModel.billDetailModel.state == SUBMIT_REPAIR_ORDER_STATE.DELETED.rawValue {
                    if !PermissionsManager.childViewPermissions() {
                        ShowMessage("当前用户对此工单没有查看权限!")
                        return;
                    }
                    self.performSegue(withIdentifier: RepairOrderChildBillDetailViewController.name(), sender: indexPath)
                    return
                }
                if !model.isEditable && !PermissionsManager.childViewPermissions() {
                    ShowMessage("当前用户对此工单没有操作权限!")
                    return;
                }
                if !model.isEditable && PermissionsManager.childViewPermissions() {
                    self.performSegue(withIdentifier: RepairOrderChildBillDetailViewController.name(), sender: indexPath)
                    return;
                }
                gotoEditingSonOrderVc(indexPath)
                break
            case SUBMIT_REPAIR_ORDER_STATE.DONE.rawValue,SUBMIT_REPAIR_ORDER_STATE.CANCLED.rawValue:
                if !PermissionsManager.childViewPermissions() {
                    ShowMessage("当前用户对此工单没有查看权限!")
                    return;
                }
                self.performSegue(withIdentifier: RepairOrderChildBillDetailViewController.name(), sender: indexPath)
                break
            default:
                break
            }
        }
    }
    
    override func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        if section == REPAIR_ORDER_DETAIL_SECTION.STATE.rawValue {
            return UIView()
        }
        return orderDetailViewModel.dequeueReusableHeaderFooterView(RepairOrderDetailSectionView.name(),tableView,section)
    }
    
    //cell的缩进级别，动态静态cell必须重写，否则会造成崩溃
    override func tableView(_ tableView: UITableView, indentationLevelForRowAt indexPath: IndexPath) -> Int {
        if indexPath.section == REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue {
            return super.tableView(tableView, indentationLevelForRowAt: IndexPath(row: 0, section: REPAIR_ORDER_DETAIL_SECTION.SUBORDER.rawValue))
        }
        return super.tableView(tableView, indentationLevelForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == REPAIR_ORDER_DETAIL_SECTION.STATE.rawValue {
            return kSectionZero
        }
        return 35
    }
    
    override func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return kSectionZero
    }
    
    // MARK: - 监听滑动改变悬浮View透明度
    override func scrollViewDidScroll(_ scrollView: UIScrollView) {
        let yoffset = scrollView.contentOffset.y
        if yoffset >= 0 {
            suspendViewAlphaBlock(1 - abs(yoffset) * kSectionZero)
        }
    }
}









