//
//  RepairOrderCompletedViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/15.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import SwiftyJSON


class RepairOrderCompletedViewController: BaseTableViewController {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 已解决
    @IBOutlet weak var resolvedButton: UIButton!
    /// 未解决
    @IBOutlet weak var unsolvedButton: UIButton!
    /// 详细完成情况
    @IBOutlet weak var remarkTextView: IQTextView!
    /// 工单完成ViewModel
    lazy final var billCompleteViewModel: RepairOrderDetailViewModel = {
        var billCompleteViewModel = RepairOrderDetailViewModel()
        return billCompleteViewModel
    }()
    
    /// 工单状态回调
    var stateBlock: BillStateBlock!


    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
    }
    
    // MARK: - 工单状态回调
    func setStateBlock(_ block: @escaping BillStateBlock) {
        self.stateBlock = block
    }

    // MARK: - UI
    fileprivate func uiConfigAction() {
        remarkTextView.placeholder = "详细完成情况"
        navigationItem.rightBarButtonItem = createButtonItem("完成", nil, self, #selector(RepairOrderCompletedViewController.saveButtonClickAction))
        resolvedButton.horizontalCenterImageAndTitle(5)
        unsolvedButton.horizontalCenterImageAndTitle(5)
    }
    
    // MARK: - 完成工单
    @objc fileprivate func saveButtonClickAction() {
        billCompleteViewModel.billCompltedModel.finishNote = remarkTextView.text
        billCompleteViewModel.billCompltedModel.finish = resolvedButton.isSelected
        billCompleteViewModel.billCompltedModel.finishTime = NSDate().httpParameterString()
        let finishModel = UCN(kUser().userCode, kUser().userName, kUser().userUuid)
        billCompleteViewModel.billCompltedModel.finishUser = finishModel
        billCompleteViewModel.complteRepairOrderAction(billCompleteViewModel.billCompltedModel).subscribe(onNext: {[weak self] () in
            self?.stateBlock(SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue)
            /// 延时一秒调用
            DispatchQueue.main.asyncAfter(deadline: DispatchTime.now() + 1.0, execute: {
                NotificationCenter.default.post(Notification(name: Notification.Name(rawValue: UPDATE_BILL_LIST)))
            })
            NotificationCenter.default.post(Notification(name: Notification.Name(rawValue: UPDATE_BILL_DETAIL_LIST)))
            ShowMessage("完成成功")
            self?.popVC()
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 已解决
    @IBAction func resolvedButtonClickAction(_ sender: UIButton) {
        sender.isSelected = true
        unsolvedButton.isSelected = false
    }
    
    // MARK: - 未解决
    @IBAction func unsolvedButtonClickAction(_ sender: UIButton) {
        sender.isSelected = true
        resolvedButton.isSelected = false
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == 0 {
            return kSectionZero
        }
        return kSectionTen
    }
    
    override func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return kSectionZero
    }
}
























