//
//  RepairOrderAddTableViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/3.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import ImagePicker
import SKPhotoBrowser
import RxSwift
import RxCocoa
import SVProgressHUD


class RepairOrderAddTableViewController: BaseTableViewController {
    
    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 来源
    @IBOutlet weak var sourceLabel: UILabel!
    /// 服务类型
    @IBOutlet weak var serviceTypeLabel: UILabel!
    /// 优先级
    @IBOutlet weak var priorityLabel: UILabel!
    /// 报事人
    @IBOutlet weak var originatorLabel: UILabel!
    /// 接报时间
    @IBOutlet weak var originatorTimeLabel: UILabel!
    /// 商户
    @IBOutlet weak var tenantLabel: UILabel!
    /// 指定时间
    @IBOutlet weak var specifiedTimeLabel: UILabel!
    /// 位置
    @IBOutlet weak var specifiedLocationLabel: UILabel!
    /// 位置图
    @IBOutlet weak var specifiedLocationImg: UIImageView!
    /// 项目
    @IBOutlet weak var projectLabel: UILabel!
    /// 设施信息
    @IBOutlet weak var facilitiesSwitch: UISwitch!
    /// 设施
    @IBOutlet weak var deviceTitleLabel: UILabel!
    /// 设施位置
    @IBOutlet weak var deviceLocationLabel: UITextField!
    /// 设置故障时间
    @IBOutlet weak var deviceFaultTimeLabel: UILabel!
    /// 联系电话
    @IBOutlet weak var phoneNumberText: UITextField!
    /// 工单描述
    @IBOutlet weak var describeTextView: IQTextView!
    /// 图片附件高度
    var attachmentHeight: CGFloat! = 0
    /// 默认section高度
    let sectionHeight: CGFloat! = 30
    /// 是否显示门店选择cell
    var isShowStoreItem: Bool = false
    /// 图片附件
    lazy final var attachmentVc: PhotoAttachmentViewController = {
       var attachmentVc = PhotoAttachmentViewController.instantiateViewController(.Function) as! PhotoAttachmentViewController
        attachmentVc.delegate = self
        return attachmentVc
    }()
    
    /// RepairOrderAddViewModel
    /// 新建工单ViewModel
    lazy final var repairOrderAddViewModel: RepairOrderAddViewModel = {
        var repairOrderAddViewModel = RepairOrderAddViewModel()
        return repairOrderAddViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        setupPhotoAttachmentVc()
        bindingRxAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        describeTextView.placeholder = "工单描述"
        describeTextView.textContainerInset = UIEdgeInsetsMake(0, 0, 0, 0)
        tableView.register(UINib(nibName: RepairAttachmentTableViewCell.name(), bundle: nil), forCellReuseIdentifier: RepairAttachmentTableViewCell.name())
        navigationItem.rightBarButtonItem = createButtonItem("提交", nil, self, #selector(RepairOrderAddTableViewController.submitButtonClickAction))
        NotificationCenter.default.rx.notification(Notification.Name(rawValue: UPDATE_REPAIRORDER_ADD_LIST)).subscribe(onNext: {[weak self] (notice) in
            let isShow = notice.object as! Int
            if isShow == kONE {
                self?.isShowStoreItem = true
            }else {
                self?.isShowStoreItem = false
            }
            self?.tableView.reloadData()
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 提交工单--上传附件
    @objc fileprivate func submitButtonClickAction() {
        if !repairOrderAddViewModel.repairOrderAvailable(facilitiesSwitch) { return }
        ShowAlertView(hint, "确认提交此工单吗？", [cancel,sure], .alert) {[weak self] (index) in
            if index == kZERO { return }
            var fileUrlArray = Array<String>()
            for i in 0..<self!.attachmentVc.attachmentViewModel.photoAttachments.count - 1 {
                let image = self?.attachmentVc.attachmentViewModel.photoAttachments[i]
                let imageName = self?.randomMD5()
                let fileUrl = self?.saveImage(currentImage: image?.attachment as! UIImage, persent: 0.8, imageName: imageName! + ".jpg")
                fileUrlArray.append(fileUrl!)
            }
            if let fileUrl = self?.repairOrderAddViewModel.saveOrderModel.locationAttachmentUrl {
                fileUrlArray.append(fileUrl)
            }
            let entityUuid = self?.randomMD5()
            guard fileUrlArray.count != kZERO else {
                self?.submitRepairBillAction(entityUuid!)
                return
            }
            var oberverArray = Array<Observable<Double>>()
            for i in 0..<fileUrlArray.count {
                let fileUrl = fileUrlArray[i]
                var model: UploadPhotoAttachmentModel!
                if i == fileUrlArray.count - kONE && self?.repairOrderAddViewModel.saveOrderModel.locationAttachmentUrl != nil {
                    model = UploadPhotoAttachmentModel(self!.randomMD5(), fileUrl, ATTACHMENT_TYPE.BILL_ATTACHMENT_TYPE.rawValue,(self?.repairOrderAddViewModel.saveOrderModel.locationAttachmentId)!)
                }else {
                    model = UploadPhotoAttachmentModel(self!.randomMD5(), fileUrl, ATTACHMENT_TYPE.BILL_ATTACHMENT_TYPE.rawValue,entityUuid!)
                }
                let signal = Observable<Double>.create({ (oberver) -> Disposable in
                    Network.upload(target: .UploadAttachment(model), progress: { (progress) in
                        oberver.onNext(progress)
                    }, success: { (json) in
                        oberver.onCompleted()
                    }, failure: { (error) in
                        oberver.onError(error)
                    })
                    return Disposables.create()
                })
                oberverArray.append(signal)
            }
            Observable.zip(oberverArray).subscribe {[weak self] (event) in
                switch event {
                case .next(let result):
                    var average: Double = 0
                    for progress in result {
                        average += progress
                    }
                    let perogress = average / Double(fileUrlArray.count)
                    ShowProgressView(Float(perogress))
                    break
                case .completed:
                    self?.submitRepairBillAction(entityUuid!)
                    break
                case .error(let error):
                    SVProgressHUD.showError(withStatus: error.localizedDescription)
                    break
                }
                }.disposed(by: self!.disposeBag)
        }
    }
    
    // MARK: - 提交工单
    fileprivate func submitRepairBillAction(_ entityUuid: String) {
        repairOrderAddViewModel.saveOrderModel.attachmentId = entityUuid
        repairOrderAddViewModel.submitRepairOrder().subscribe(onNext: {[weak self] (result) in
            NotificationCenter.default.post(Notification(name: Notification.Name(rawValue: UPDATE_BILL_LIST)))
            self?.popVC()
            ShowMessage("提交成功")
        }).disposed(by: disposeBag)
    }
    
    // MARK: - 设置附件VC
    fileprivate func setupPhotoAttachmentVc(){
        addChildViewController(attachmentVc)
        attachmentVc.attachmentViewModel.photoAttachments.append(PhotoAttachmentModel(add_Photo, .ATTACHMENT_ADD))
        attachmentHeight = attachmentVc.attachmentHeight(kONE,nil)
    }
    
    // MARK: - 绑定RxSwift事件
    fileprivate func bindingRxAction() {
        facilitiesSwitch.rx.controlEvent(UIControlEvents.valueChanged).subscribe(onNext: {[weak self] (event) in
            self?.tableView.reloadData()
        }).disposed(by: disposeBag)
        
        describeTextView.rx.text.subscribe(onNext: {[weak self] (string) in
            self?.repairOrderAddViewModel.saveOrderModel.descriptionField = string
        }).disposed(by: disposeBag)
        
        phoneNumberText.rx.text.subscribe(onNext: {[weak self] (string) in
            self?.repairOrderAddViewModel.saveOrderModel.reporterPhone = string
        }).disposed(by: disposeBag)
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.section == REPAIR_ORDER_SECTION.ATTACHMENT.rawValue {
            let attachmentCell = tableView.dequeueReusableCell(withIdentifier: RepairAttachmentTableViewCell.name(), for: indexPath) as! RepairAttachmentTableViewCell
            attachmentVc.view.frame = CGRect(x: 15, y: 35, width: kWidth - 30, height: attachmentHeight)
            attachmentCell.contentView.addSubview(attachmentVc.view)
            return attachmentCell
        }
        return super.tableView(tableView, cellForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.section == REPAIR_ORDER_SECTION.BASIC.rawValue && indexPath.row == 2 {
            if isShowStoreItem {
                return kCellHeight
            }
            return 0
        }
        if indexPath.section == REPAIR_ORDER_SECTION.ATTACHMENT.rawValue {
            return attachmentHeight + 50
        }
        return super.tableView(tableView, heightForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if section == REPAIR_ORDER_SECTION.FACILITY.rawValue && !facilitiesSwitch.isOn {
            return kZERO
        }
        if section == REPAIR_ORDER_SECTION.ATTACHMENT.rawValue {
            return kONE
        }
        return super.tableView(tableView, numberOfRowsInSection: section)
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == REPAIR_ORDER_SECTION.BASIC.rawValue {
            return sectionHeight
        }
        if section == REPAIR_ORDER_SECTION.FACILITY.rawValue {
            if facilitiesSwitch.isOn {
                return sectionHeight
            }
            return kSectionZero
        }
        return kSectionTen
    }
    
    override func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return kSectionZero
    }
    
    override func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        if section == REPAIR_ORDER_SECTION.FACILITY.rawValue && !facilitiesSwitch.isOn {
            return UIView()
        }
        return super.tableView(tableView, viewForHeaderInSection: section)
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        repairOrderAddViewModel.didSelectRowAtIndePath(indexPath, self)
    }
}

// MARK: - 更新附件高度
extension RepairOrderAddTableViewController: PhotoAttachmentDelegate {
    func updatePhotoAttachment(_ height: CGFloat, _ key: String?) {
        attachmentHeight = height
        tableView.reloadData()
    }
}












