//
//  AccountTableViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import Kingfisher
import RxSwift
import PPBadgeViewSwift

class AccountTableViewController: BaseTableViewController {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 用户头像
    @IBOutlet weak var userHeaderImg: UIImageView!
    /// 用户名
    @IBOutlet weak var userNameLab: UILabel!
    /// 检查版本更新
    @IBOutlet weak var checkVersionLabel: UILabel!
    /// 账户背景
    @IBOutlet weak var accountBgView: UIView!
    
    /// 版本更新
    var updateVerison: String?
    
    /// 账户VieWModel
    lazy final var accountViewModel: AccountViewModel = {
       var accountViewModel = AccountViewModel()
        return accountViewModel;
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        uiConfigAction()
        dataAction()
        updateVersion()
    }

    // MARK: - 状态栏风格
    override var preferredStatusBarStyle: UIStatusBarStyle {
        return .lightContent
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        self.fd_prefersNavigationBarHidden = true
        userHeaderImg.addAngle(kWidth * 0.15 * 0.5)
        userHeaderImg.addBorder(1.0, UIColor.white)
        accountBgView.seth(h: kWidth * 9 / 16)
    }
    
    // MARK: - 填充数据
    fileprivate func dataAction() {
        userNameLab.text = kUser().userName
        userHeaderImg.image = UIDevice.appIcon()
    }
    
    // MARK: - 检查版本更新
    fileprivate func updateVersion() {
        let viewModel = BaseViewModel()
        viewModel.updateVersion().subscribe(onNext: {[weak self] (result) in
            self?.updateVerison = result.1
            if result.0 {
                ShowAlertView(hint, String(format: "检测到有新版本<%@>需要更新", result.2), ["我知道了"], UIAlertControllerStyle.alert, { (index) in
                    UIApplication.shared.openURL(URL(string: result.1)!)
                })
            }else {
                self?.checkVersionLabel.pp.addBadge(text: "新版本")
            }
        }).disposed(by: disposeBag)
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return kSectionTen
    }
    
    override func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return kSectionZero
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        switch indexPath {
        case IndexPath(row: 2, section: 0):
            guard updateVerison != nil else {
                ShowMessage("暂无更新")
                return
            }
            UIApplication.shared.openURL(URL(string: updateVerison!)!)

            break
        case IndexPath(row: 0, section: 1):
            accountViewModel.loginOutAction()
            break
        default:
            break
        }
        
    }
}






















