//
//  WebViewController.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/1.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit
import WebKit
import SnapKit
import RxSwift



/// 获取用户token使用
protocol LoginDelegate {
    func getTokenByCode(code: String)
}

class WebViewController: BaseViewController {

    var delegate: LoginDelegate?
    
    // MARK: - WKWebView
    fileprivate final lazy var webView: WKWebView = {
       let webView = WKWebView()
        webView.navigationDelegate = self
        webView.uiDelegate = self
        return webView
    }()
    
    fileprivate final var htmlResuest: URLRequest!
    final let progress: String = "estimatedProgress"

    // MARK: - 进度条
    fileprivate final lazy var progressView: UIProgressView = {
       let progressView = UIProgressView()
        progressView.trackTintColor = UIColor.white
        progressView.progressTintColor = kMainColor
        progressView.frame = CGRect(x: 0, y: 44 - 2, width: kWidth, height: 2)
        return progressView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        setupProgressView()
        setupWebView()
    }

    // MARK: - 自定义进度条
    fileprivate func setupProgressView() {
        self.navigationController?.navigationBar.addSubview(progressView)
        webView.addObserver(self, forKeyPath: progress, options: .new, context: nil)
    }
    
    // MARK: - 监听网页加载进度回调
    override func observeValue(forKeyPath keyPath: String?, of object: Any?, change: [NSKeyValueChangeKey : Any]?, context: UnsafeMutableRawPointer?) {
        if (keyPath == progress) {
            progressView.alpha = 1.0
            progressView.setProgress(Float(webView.estimatedProgress), animated: true)
            if webView.estimatedProgress >= 1.0 {
                UIView.animate(withDuration: 0.3, delay: 0.1, options: .curveEaseOut, animations: {
                    self.progressView.alpha = 0
                }, completion: { (finish) in
                    self.progressView.setProgress(0.0, animated: false)
                })
            }
        }
    }
    
    // MARK: - 自定义初始化方法
    init(_ htmlString: String) {
        super.init(nibName: nil, bundle: nil)
        title = "WebView"
        htmlResuest = URLRequest(url: URL(string: htmlString)!)
    }
    
    required init?(coder aDecoder: NSCoder) {
        super.init(coder: aDecoder)
        fatalError("init(coder:) has not been implemented")
    }
    
    // MARK: - 初始化WKWebView
    fileprivate func setupWebView() {
        view.addSubview(webView)
        webView.snp.makeConstraints { (make) in
            make.edges.equalTo(view)
        }
        webView.load(htmlResuest)
    }
    
    deinit {
        print("con is deinit")
        webView.removeObserver(self, forKeyPath: progress)
        webView.uiDelegate = nil
        webView.navigationDelegate = nil
        progressView.removeFromSuperview()
    }
}

extension WebViewController: WKNavigationDelegate,WKUIDelegate {

    func webView(_ webView: WKWebView, didStartProvisionalNavigation navigation: WKNavigation!) {
        print("开始加载")
        startLoading()
    }

    func webView(_ webView: WKWebView, didFinish navigation: WKNavigation!) {
        print("加载完成")
        title = webView.title
        stopLoading()
    }
    
    func webView(_ webView: WKWebView, didFail navigation: WKNavigation!, withError error: Error) {
        print("加载失败")
        stopLoading()
    }
    
    func webView(_ webView: WKWebView, createWebViewWith configuration: WKWebViewConfiguration, for navigationAction: WKNavigationAction, windowFeatures: WKWindowFeatures) -> WKWebView? {
        if !(navigationAction.targetFrame?.isMainFrame)! {
            webView.load(navigationAction.request)
        }
        return nil
    }
    
    func webView(_ webView: WKWebView, decidePolicyFor navigationAction: WKNavigationAction, decisionHandler: @escaping (WKNavigationActionPolicy) -> Void) {
        var urlString = navigationAction.request.url?.host
        //拦截GitHub回调地址，获取用户code
        //再通过code获取用户token
        //本项目中所有接口均需要token才能正常访问
        if (urlString?.contains("www.jianshu.com"))! {
            urlString = navigationAction.request.url?.absoluteString
            var array = urlString?.components(separatedBy: "code=")
            if !(array?.isEmpty)! {
                array = array?.last?.components(separatedBy: "&")
                delegate?.getTokenByCode(code: (array?.first)!)
            }
        }
        decisionHandler(.allow);
    }    
}







