//
//  FilterViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/4.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift

class FilterViewModel: BaseViewModel {

    /// 公共过滤数组,需要把外界传入数据转化为此类型
    lazy final var filterArray: NSMutableArray = {
        var filterArray = NSMutableArray()
        return filterArray
    }()
    
    /// 过滤后显示数据源
    lazy final var displayArray: NSArray = {
        var displayArray = NSArray()
        return displayArray
    }()
}

// MARK: - UI
extension FilterViewModel {
    
    func dequeueReusableCell(_ indexPath: IndexPath,_ identifier: String, _ tableView: UITableView) ->UITableViewCell {
        let publicFilterCell = tableView.dequeueReusableCell(withIdentifier: identifier, for: indexPath) as! FilterTableViewCell
        let model = displayArray[indexPath.row] as! PublicFilterModel
        publicFilterCell.accessoryType = model.isSelected == "\(kONE)" ? .checkmark : .none
        publicFilterCell.titleLabel.text = model.title
        return publicFilterCell
    }
    
    // MARK: - 选择item
    func deselectRow(_ indexPath: IndexPath, _ type: FILTER_TYPE){
        if (displayArray[indexPath.row] as! PublicFilterModel).isSelected == "\(kONE)" {
            (displayArray[indexPath.row] as! PublicFilterModel).isSelected = "\(kZERO)"
        }else {
            if type == .SINGLE {
                for model in displayArray {
                    (model as! PublicFilterModel).isSelected = "\(kZERO)"
                }
                for model in filterArray {
                    (model as! PublicFilterModel).isSelected = "\(kZERO)"
                }
            }
            (displayArray[indexPath.row] as! PublicFilterModel).isSelected = "\(kONE)"
        }
    }
}

// MARK: - 数据请求
extension FilterViewModel {
    // MARK: - 查询工程发起方
    func queryProjectSponsors() ->Observable<[String]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QuerySource(), success: { (json) in
                let resultModel = ProjectSponsorsModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 查询项目
    func queryProjectType() ->Observable<[ProjectResultRecord]> {
        let queryModel = ProjectQueryModel()
        queryModel.userId = kUser().userUuid
        queryModel.nameLike = AppManager.shareInstance.userStoreModel?.name
        queryModel.codeEquals = AppManager.shareInstance.userStoreModel?.code
        queryModel.enabled = true
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryProjectOption(queryModel), success: { (json) in
                let resultModel = ProjectResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data.records)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 查询商户
    func queryTenant(_ model: QueryModel) ->Observable<[TenantRecord]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryTenant(model), success: { (json) in
                let resultModel = TenantResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data.records)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 查询服务类型
    func queryServerType() ->Observable<[String]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryServerType(), success: { (json) in
                let resultModel = ProjectSponsorsModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 查询优先级
    func queryProrityOption() ->Observable<[String]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryPrority(), success: { (json) in
                let resultModel = ProjectSponsorsModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 查询报事人
    func queryInitiator(_ model: QueryModel) ->Observable<[InitiatorResultData]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryInitiator(model), success: { (json) in
                let resultModel = InitiatorResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 查询报事人位置
    func queryLocation(_ model: QueryModel) ->Observable<[LocationRecord]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryPosition(model), success: { (json) in
                let resultModel = LocationModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data.records)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 查询设施
    func queryDevice(_ model: DeviceQueryModel) ->Observable<[DeviceRecord]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryDevice(model), success: { (json) in
                let resultModel = DeviceModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data.records)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 主管指引/备件/工具
    func queryToolOption() ->Observable<[String]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryToolOption(), success: { (json) in
                let resultModel = ProjectSponsorsModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 安全/防护/围封/环保
    func queryProtectOption() ->Observable<[String]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryProtectOption(), success: { (json) in
                let resultModel = ProjectSponsorsModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 故障原因
    func queryBrokenOption() ->Observable<[String]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QuerybrokenOption(), success: { (json) in
                let resultModel = ProjectSponsorsModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 处理方式
    func queryProcessMethods() ->Observable<[String]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryprocessMethods(), success: { (json) in
                let resultModel = ProjectSponsorsModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 获取楼宇
    func queryFlooryu(_ model: FlooryuQueryModel) ->Observable<[FlooryuRecord]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .Queryflooryu(model), success: { (json) in
                let resultModel = FlooryuResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data.records)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
    
    // MARK: - 通过获取楼层导览图
    func queryFloorlayer(_ uuid: String) ->Observable<[FloorLayerData]> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .Queryfloorlayer(uuid), success: { (json) in
                let resultModel = FloorLayerResultModel(fromJson: json)
                if resultModel.success {
                    if !resultModel.data.isEmpty {
                        observer.onNext(resultModel.data!)
                    }
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
}









