//
//	StoreResultModel.swift
//
//	Create by 云霄 曹 on 1/2/2018
//	Copyright © 2018. All rights reserved.
//	Model file generated using JSONExport: https://github.com/Ahmed-Ali/JSONExport

import Foundation 
import SwiftyJSON


class StoreResultModel : NSObject{

	var data : StoreResultData!
	var message : String!
	var success : Bool!

	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		let dataJson = json["data"]
		if !dataJson.isEmpty{
			data = StoreResultData(fromJson: dataJson)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			dictionary["data"] = data.toDictionary()
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}
}


class StoreResultData : NSObject{
    
    var code : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var enabled : Bool!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var name : String!
    var upper : Upper!
    var uuid : String!
    var version : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        code = json["code"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        enabled = json["enabled"].boolValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        name = json["name"].stringValue
        let upperJson = json["upper"]
        if !upperJson.isEmpty{
            upper = Upper(fromJson: upperJson)
        }
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if code != nil{
            dictionary["code"] = code
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if enabled != nil{
            dictionary["enabled"] = enabled
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if name != nil{
            dictionary["name"] = name
        }
        if upper != nil{
            dictionary["upper"] = upper.toDictionary()
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        return dictionary
    }
}



