//
//	FloorLayerResultModel.swift
//
//	Create by 云霄 曹 on 1/2/2018
//	Copyright © 2018. All rights reserved.

import Foundation 
import SwiftyJSON


class FloorLayerResultModel : NSObject{

	var data : [FloorLayerData]!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		data = [FloorLayerData]()
		let dataArray = json["data"].arrayValue
		for dataJson in dataArray{
			let value = FloorLayerData(fromJson: dataJson)
			data.append(value)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
		var dictionary = [String:Any]()
		if data != nil{
			var dictionaryElements = [[String:Any]]()
			for dataElement in data {
				dictionaryElements.append(dataElement.toDictionary())
			}
			dictionary["data"] = dictionaryElements
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}
}

class FloorLayerData : NSObject{
    
    var attachmentId : String!
    var attachments : [Attachment]!
    var code : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var enabled : Bool!
    var floor : UCN!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var name : String!
    var note : AnyObject!
    var store : UCN!
    var uuid : String!
    var version : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        attachmentId = json["attachmentId"].stringValue
        attachments = [Attachment]()
        let attachmentsArray = json["attachments"].arrayValue
        for attachmentsJson in attachmentsArray{
            let value = Attachment(fromJson: attachmentsJson)
            attachments.append(value)
        }
        code = json["code"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        enabled = json["enabled"].boolValue
        let floorJson = json["floor"]
        if !floorJson.isEmpty{
            floor = UCN(fromJson: floorJson)
        }
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        name = json["name"].stringValue
        note = json["note"].stringValue as AnyObject
        let storeJson = json["store"]
        if !storeJson.isEmpty{
            store = UCN(fromJson: storeJson)
        }
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if attachmentId != nil{
            dictionary["attachmentId"] = attachmentId
        }
        if attachments != nil{
            var dictionaryElements = [[String:Any]]()
            for attachmentsElement in attachments {
                dictionaryElements.append(attachmentsElement.toDictionary())
            }
            dictionary["attachments"] = dictionaryElements
        }
        if code != nil{
            dictionary["code"] = code
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if enabled != nil{
            dictionary["enabled"] = enabled
        }
        if floor != nil{
            dictionary["floor"] = floor.toDictionary()
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if name != nil{
            dictionary["name"] = name
        }
        if note != nil{
            dictionary["note"] = note
        }
        if store != nil{
            dictionary["store"] = store.toDictionary()
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        return dictionary
    }
}

class Attachment : NSObject{
    
    var entityType : String!
    var entityUuid : String!
    var fileName : String!
    var fileUrl : String!
    var lastModified : String!
    var thumbnailFileName : AnyObject!
    var uuid : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        entityType = json["entityType"].stringValue
        entityUuid = json["entityUuid"].stringValue
        fileName = json["fileName"].stringValue
        fileUrl = json["fileUrl"].stringValue
        lastModified = json["lastModified"].stringValue
        thumbnailFileName = json["thumbnailFileName"].stringValue as AnyObject
        uuid = json["uuid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if entityType != nil{
            dictionary["entityType"] = entityType
        }
        if entityUuid != nil{
            dictionary["entityUuid"] = entityUuid
        }
        if fileName != nil{
            dictionary["fileName"] = fileName
        }
        if fileUrl != nil{
            dictionary["fileUrl"] = fileUrl
        }
        if lastModified != nil{
            dictionary["lastModified"] = lastModified
        }
        if thumbnailFileName != nil{
            dictionary["thumbnailFileName"] = thumbnailFileName
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        return dictionary
    }
    
}

class Upper : NSObject{
    
    var code : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var enabled : Bool!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var name : String!
    var upper : AnyObject!
    var uuid : String!
    var version : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        code = json["code"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        enabled = json["enabled"].boolValue
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        name = json["name"].stringValue
        upper = json["upper"].stringValue as AnyObject
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if code != nil{
            dictionary["code"] = code
        }
        if createId != nil{
            dictionary["create_id"] = createId
        }
        if createOperName != nil{
            dictionary["create_operName"] = createOperName
        }
        if createTime != nil{
            dictionary["create_time"] = createTime
        }
        if enabled != nil{
            dictionary["enabled"] = enabled
        }
        if lastModifyId != nil{
            dictionary["lastModify_id"] = lastModifyId
        }
        if lastModifyOperName != nil{
            dictionary["lastModify_operName"] = lastModifyOperName
        }
        if lastModifyTime != nil{
            dictionary["lastModify_time"] = lastModifyTime
        }
        if name != nil{
            dictionary["name"] = name
        }
        if upper != nil{
            dictionary["upper"] = upper
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        if version != nil{
            dictionary["version"] = version
        }
        return dictionary
    }
    
}
















