//
//  FilterViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/4.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit


/// 确认选择后回传数据
typealias SendValueClosure = ([PublicFilterModel],Int?) ->Void

class FilterViewController: BaseViewController {

    /// 搜索关键字
    @IBOutlet weak var searchBar: UISearchBar!
    /// 搜索
    @IBOutlet weak var filterTablView: UITableView!
    
    /// 公共过滤ViewModel
    lazy final var publicViewModel: FilterViewModel = {
        var publicViewModel = FilterViewModel()
        return publicViewModel;
    }()
    
    /// 回传数据
    var affirmSelectedBlock: SendValueClosure?
    
    /// 选择类型
    /// 单选、多选
    var choiceType: FILTER_TYPE?
    
    override func viewDidLoad() {
        super.viewDidLoad()

        addBarButtonItem()
        setupConfigAction()
    }
    
    // MARK: - 添加提交按钮
    fileprivate func addBarButtonItem() {
        navigationItem.rightBarButtonItem = createButtonItem("确认", nil, self, #selector(FilterViewController.affirmButtonClickAction))
    }
    
    // MARK: - 设置导航栏
    open func setNavigationTitle(_ title: String,_ type: FILTER_TYPE, _ block: @escaping SendValueClosure) {
        self.title = title
        self.affirmSelectedBlock = block
        self.choiceType = type
    }
    
    // MARK: - 初始化
    func setupConfigAction() {
        publicViewModel.displayArray = NSArray(array: publicViewModel.filterArray)
        filterTablView.reloadData()
    }
    
    // MARK: - 确认选择
    @objc func affirmButtonClickAction() {
        if let affirmSelectedBlock = affirmSelectedBlock {
            let predicate = NSPredicate(format: "isSelected=%@", "\(kONE)")
            let tempArray = publicViewModel.displayArray.filtered(using: predicate)
            guard tempArray.count > kZERO else {
                ShowMessage("请选择至少一项")
                return
            }
            popVC()
            if choiceType == FILTER_TYPE.SINGLE {
                let model = tempArray.first as! PublicFilterModel
                affirmSelectedBlock(tempArray as! [PublicFilterModel], publicViewModel.filterArray.index(of: model))
            }else {
                affirmSelectedBlock(tempArray as! [PublicFilterModel], nil)
            }
        }
    }
}

// MARK: - UITableViewDelegate,UITableDataSource
extension FilterViewController: UITableViewDelegate,UITableViewDataSource {
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        return publicViewModel.dequeueReusableCell(indexPath, FilterTableViewCell.name(), tableView)
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return publicViewModel.displayArray.count
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        view.endEditing(true)
        publicViewModel.deselectRow(indexPath,choiceType!)
        tableView.reloadData()
    }
}

extension FilterViewController: UISearchBarDelegate {

    func searchBar(_ searchBar: UISearchBar, textDidChange searchText: String) {
        let predicate = NSPredicate(format: "title CONTAINS [cd] %@ ", searchText)
        publicViewModel.displayArray = publicViewModel.filterArray.filtered(using: predicate) as NSArray
        if searchText.isEmpty {
            publicViewModel.displayArray = NSArray(array: publicViewModel.filterArray)
        }
        filterTablView.reloadData()
    }
}















