//
//  Enums.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/11/29.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import Foundation


/// 功能菜单
///
/// - TODO: 待办事项
/// - REPAIRORDER: 工单
public enum FunctionType: String {
    case TODO = "待办事项"
    case REPAIRORDER = "工单"
}


/// 图片附件类型
///
/// - ATTACHMENT_HTTP: 网络图片
/// - ATTACHMENT_LOCAL: 本地图片
/// - ATTACHMENT_ADD: 本地图片
public enum ATTACHMENT_LOCATION: String {
    case ATTACHMENT_HTTP = "http"
    case ATTACHMENT_LOCAL = "local"
    case ATTACHMENT_ADD = "add"
}


/// 图片上传类型
///
/// - BILL_ATTACHMENT_TYPE: 工单上传类型
/// - CHILD_BILL_ATTACHMENT_TYPE: 子工单上传类型
public enum ATTACHMENT_TYPE: String {
    case BILL_ATTACHMENT_TYPE = "workbill"
    case CHILD_BILL_ATTACHMENT_TYPE = "WorkExecute"
}


/// 新建工单界面分区
///
/// - BASIC: 基本信息
/// - FACILITY: 设施信息
/// - DESCRIBE: 工单描述
/// - ATTACHMENT: 图片附件
public enum REPAIR_ORDER_SECTION: Int {
    case BASIC = 0
    case FACILITY
    case DESCRIBE
    case ATTACHMENT
}


/// 子工单详情界面分区
///
/// - STATE: 工单状态
/// - SOURCE: 工单来源
/// - COST: 费用
/// - BORROW: 借用
/// - DESCRIBE: 描述
public enum CHILD_BILL_DETAIL_SECTION: Int {
    case STATE = 0
    case SOURCE
    case COST
    case BORROW
    case DESCRIBE
}

/// 工单详情界面分区
///
/// - STATE: 工单状态
/// - SOURCE: 工单来源
/// - SUBORDER: 子工单
/// - COMPLETED: 完成情况
public enum REPAIR_ORDER_DETAIL_SECTION: Int {
    case STATE = 0
    case SOURCE
    case SUBORDER
    case COMPLETED
}


/// 子工单编辑界面分区
///
/// - BASIC: 基本信息
/// - COST: 费用信息
/// - BORROW: 借用信息
/// - DESCRIBE: 描述
/// - AFTERATTACHMENT: 维修前照片
/// - BEFORATTACHMENT: 维修后照片
public enum CHILD_BILL_EDIT_SECTION: Int {
    case BASIC = 0
    case COST
    case BORROW
    case DESCRIBE
    case BEFORATTACHMENT
    case AFTERATTACHMENT
}


/// 待办事项状态
///
/// - INIT: 未开始
/// - DREW: 已领单
/// - ALL:  全部
public enum TODO_STATE: String {
    case INIT = "init"
    case DREW = "drew"
    case ALL = "all"
}


/// 工单状态类型
///
/// - CREATED: 未发出
/// - SUBMIT: 已发出
/// - PROCESSING: 处理中
/// - FINISHED: 已完成
/// - DELETED: 已删除
/// - CANCLED: 已作废
/// - INIT: 未开始
/// - DREW: 已领单
/// - DONE: 已作废

public enum SUBMIT_REPAIR_ORDER_STATE: String {
    case CREATED = "created"
    case SUBMIT = "submit"
    case PROCESSING = "processing"
    case FINISHED = "finished"
    case DELETED = "deleted"
    case CANCLED = "cancled"
    case ALL = ""
    case INIT = "init"
    case DREW = "drew"
    case DONE = "done"
}

/// 工单状态码转中文
///
/// - Parameter state: 状态码
/// - Returns:         对应中文
public func repairOrderChineseState(_ state: String) ->String {
    switch state {
    case SUBMIT_REPAIR_ORDER_STATE.CREATED.rawValue:
        return "未发出"
    case SUBMIT_REPAIR_ORDER_STATE.SUBMIT.rawValue:
        return "已发出"
    case SUBMIT_REPAIR_ORDER_STATE.PROCESSING.rawValue:
        return "处理中"
    case SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue:
        return "已完成"
    case SUBMIT_REPAIR_ORDER_STATE.DELETED.rawValue:
        return "已删除"
    case SUBMIT_REPAIR_ORDER_STATE.CANCLED.rawValue:
        return "已作废"
    case SUBMIT_REPAIR_ORDER_STATE.INIT.rawValue:
        return "未开始"
    case SUBMIT_REPAIR_ORDER_STATE.DONE.rawValue:
        return "已完成"
    case SUBMIT_REPAIR_ORDER_STATE.DREW.rawValue:
        return "已领单"
    default:
        break
    }
    return "未知状态"
}

/// 工单状态码转英文
///
/// - Parameter state: 状态码
/// - Returns:         对应英文
public func repairOrderEnglishState(_ state: String) ->String {
    switch state {
    case "未发出":
        return SUBMIT_REPAIR_ORDER_STATE.CREATED.rawValue
    case "未派单":
        return SUBMIT_REPAIR_ORDER_STATE.SUBMIT.rawValue
    case "处理中":
        return SUBMIT_REPAIR_ORDER_STATE.PROCESSING.rawValue
    case "已完成":
        return SUBMIT_REPAIR_ORDER_STATE.FINISHED.rawValue
    case "已删除":
        return SUBMIT_REPAIR_ORDER_STATE.DELETED.rawValue
    case "已作废":
        return SUBMIT_REPAIR_ORDER_STATE.CANCLED.rawValue
    case "全部状态":
        return ""
    default:
        break
    }
    return "未知状态"
}

/// 工单列表过滤器
///
/// - TIME: 时间
/// - STATE: 状态
/// - SOURCE: 来源
/// - PRIORITY: 优先级
public enum REPAIR_ORDER_FILTER_BUTTON_TAG: Int {
    case TIME = 0
    case STATE
    case SOURCE
    case PRIORITY
}

/// 过滤界面选择类型
///
/// - SINGLE: 单选
/// - MULTIPLE: 多选
public enum FILTER_TYPE: Int {
    case SINGLE = 0
    case MULTIPLE
}

/// 工单详情悬浮框按钮
///
/// - GET: 领取
/// - COMPLETED: 完成
public enum SUSPEND_BUTTON_TYPE: String {
    case GET = "领单"
    case COMPLETED = "完成"
}


/// 新建工单位置图类型
///
/// - EDIT: 编辑
/// - VIEW: 查看
public enum LOCATION_IMAGE_TYPE: Int {
    case EDIT = 0
    case VIEW
}


/// 新建工单是否显示门店
///
/// - SHOW: 显示
/// - HIDE: 隐藏
public enum REPAIRORDER_STORE: Int {
    case HIDE = 0
    case SHOW
}


/// 子工单详情费用信息和借用信息区分
///
/// - COST: 费用信息
/// - BORROW: 借用信息
public enum CHILDORDERCOST_TYPE: String {
    case COST = "outputBill"
    case BORROW = "borrowbill"
}























