//
//  LoginViewController.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/4.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit
import RxCocoa
import RxSwift

class LoginViewController: UIViewController {
    
    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 登录按钮
    @IBOutlet weak var loginButton: UIButton!
    /// 用户名
    @IBOutlet weak var userNameTextField: UITextField!
    @IBOutlet weak var userNameLineView: UIView!
    /// 密码
    @IBOutlet weak var passwordTextField: UITextField!
    @IBOutlet weak var passwordLineView: UIView!
    
    /// 登录ViewModel
    lazy final var loginViewModel: LoginViewModel = {
        var loginViewModel = LoginViewModel()
        return loginViewModel
    }()
    
    // MARK: - 隐藏状态栏
    override var prefersStatusBarHidden: Bool {
        return true
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        bindingRxAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        loginButton.addAngle(25.0)
    }
    
    // MARK: - 登录
    @IBAction func loginButtonClickAction(_ sender: UIButton) {
        loginViewModel.loginRequest(userNameTextField.text!, passwordTextField.text!).subscribe(onNext: { (event) in
            AppManager.shareInstance.openMainVc()
        }).disposed(by: disposeBag)
    }
    
    // MARK: - UITextField绑定RxSwift事件
    fileprivate func bindingRxAction() {
        userNameTextField.rx.text.map { (text) -> Bool in
            if (text?.isEmpty)! {
                return false
            }
            return true
            }.subscribe(onNext: {[weak self] (boolValue) in
                self?.userNameLineView.backgroundColor = boolValue ? kBlueColor : kGaryColor
            }).disposed(by: disposeBag)
        passwordTextField.rx.text.map { (text) -> Bool in
                if (text?.isEmpty)! {
                    return false
                }
                return true
            }.subscribe(onNext: {[weak self] (boolValue) in
                self?.passwordLineView.backgroundColor = boolValue ? kBlueColor : kGaryColor
            }).disposed(by: disposeBag)
        Observable.combineLatest(userNameTextField.rx.text.orEmpty,passwordTextField.rx.text.orEmpty).map { (arg) -> Bool in
            let (userName, passowrd) = arg
            return userName.count > 0 && passowrd.count > 0
            }.subscribe(onNext: {[weak self] (bool) in
                self?.loginButton.isEnabled = bool
                self?.loginButton.alpha = bool ? 1 : 0.5
            }).disposed(by: disposeBag)
        
    }
}














