//
//  AppStyle.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/1.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import Foundation
import UIKit
import SVProgressHUD


class AppStyle: NSObject {

    // MARK: - App风格
    open class func setupAppStyle() {
        navigationStyle()
        thirdFrameworkStyle()
    }
    
    // MARK: - 设置导航栏风格
    fileprivate class func navigationStyle() {
        let bar = UINavigationBar.appearance()
        bar.tintColor = UIColor.white
        bar.barTintColor = kNavColor
        bar.isTranslucent = false
        bar.barStyle = .black
        bar.titleTextAttributes = [NSAttributedStringKey.foregroundColor:UIColor.white,NSAttributedStringKey.font:UIFont.boldSystemFont(ofSize:20)]
    }
    
    // MARK: - 第三方框架
    fileprivate class func thirdFrameworkStyle() {
        SVProgressHUD.setBackgroundColor(kGaryColor)
        SVProgressHUD.setMinimumDismissTimeInterval(TimeInterval(CGFloat.greatestFiniteMagnitude))
        SVProgressHUD.resetOffsetFromCenter()
        SVProgressHUD.setDefaultMaskType(.clear)
        UMAnalyticsConfig.sharedInstance().appKey = UMKey
        MobClick.start(withConfigure: UMAnalyticsConfig.sharedInstance())
        MobClick.setLogEnabled(true)
    }
}



















