//
//  HomeViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import SnapKit
import RxSwift

class HomeViewController: BaseViewController {

    
    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    
    /// 子视图背景View
    @IBOutlet weak var contentBgView: UIView!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        addChildContentVc()
        updateVersion()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        contentBgView.addAngle(10.0)
        contentBgView.addShadow(UIColor.black)
    }

    // MARK: - 添加子控制器到主控制器
    fileprivate func addChildContentVc() {
        let homeContentVc = HomeContentViewController.instantiateViewController(.Home)
        addChildViewController(homeContentVc)
        contentBgView.addSubview(homeContentVc.view)
        homeContentVc.view.snp.makeConstraints { (make) in
            make.edges.equalTo(contentBgView)
        }
    }
    
    // MARK: - 检查版本更新
    fileprivate func updateVersion() {
        let viewModel = BaseViewModel()
        viewModel.getStoreByUser()
        viewModel.updateVersion().subscribe(onNext: { (result) in
            if result.0 {
                ShowAlertView(hint, String(format: "检测到有新版本<%@>需要更新", result.2), ["我知道了"], UIAlertControllerStyle.alert, { (index) in
                    UIApplication.shared.openURL(URL(string: result.1)!)
                })
            }
        }).disposed(by: disposeBag)
        
        
        
    }
}






















