//
//  TodoViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/5.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import Moya

class TodoViewModel: BaseViewModel {

    /// 查询待办事项model
    lazy final var queryModel: QueryTodoModel = {
        var queryModel = QueryTodoModel()
        queryModel.entityType = "work"
        queryModel.userId = kUser().userUuid
        return queryModel
    }()
    
    /// 待办事项结果
    lazy final var todoResultArray: Array<TodoData> = {
       var todoResultArray = Array<TodoData>()
        return todoResultArray
    }()
    
    
    /// 查询待办事项
    ///
    /// - Parameters:
    ///   - page: 页数
    ///   - state: 状态
    func queryTodoAction(_ state: TODO_STATE) ->Observable<Void> {
        queryModel.stateEquals = state.rawValue
        if state == .ALL {
            queryModel.stateEquals = nil
        }
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryTodo(self.queryModel), success: {[weak self] (json) in
                let resultModel = TodoResultModel(fromJson: json)
                if resultModel.success {
                    self?.todoResultArray.removeAll()
                    for data in resultModel.data {
                        self?.todoResultArray.append(data)
                    }
                    observer.onNext(())
                }else {
                    ShowMessage(resultModel.message)
                    observer.onError(MoyaError.requestMapping(resultModel.message))
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
}

extension TodoViewModel {
    
    /// 待办事项菜单调用
    func dequeueReusableCell(_ identifier: String, _ indexPath: IndexPath, _ tableView: UITableView) -> UITableViewCell {
        let todoCell = tableView.dequeueReusableCell(withIdentifier: identifier, for: indexPath) as! TodoTableViewCell
        todoCell.updateTodoCell(todoResultArray[indexPath.item],indexPath)
        return todoCell
    }
    
    /// 首页待办事项调用
    func dequeueReusableHomeCell(_ identifier: String, _ indexPath: IndexPath, _ tableView: UITableView) -> UITableViewCell {
        let todoCell = tableView.dequeueReusableCell(withIdentifier: identifier, for: indexPath) as! HomeTableViewCell
        todoCell.updateTodoCell(todoResultArray[indexPath.item],indexPath)
        return todoCell
    }
}





