//
//  TodoTableViewCell.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/5.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class TodoTableViewCell: UITableViewCell {

    
    /// 标题 + code
    @IBOutlet weak var titleCodeLabel: UILabel!
    /// 操作时间
    @IBOutlet weak var operationDateLabel: UILabel!
    /// 状态
    @IBOutlet weak var todoStateLabel: UILabel!
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    // MARK: - 更新待办cell
    func updateTodoCell(_ model: TodoData, _ indexPath: IndexPath) {
        titleCodeLabel.text = String(format: "%@（%@）", model.dept.name,model.dept.code)
        operationDateLabel.text = String(format: "转交时间：%@", model.dateTime)
        todoStateLabel.text = repairOrderChineseState(model.state)
    }

}
