//
//	TodoResultModel.swift
//
//	Create by 云霄 曹 on 9/1/2018

import Foundation 
import SwiftyJSON

class TodoResultModel{

    var data : [TodoData]!
    var message : String!
    var success : Bool!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        data = [TodoData]()
        let dataArray = json["data"].arrayValue
        for dataJson in dataArray{
            let value = TodoData(fromJson: dataJson)
            data.append(value)
        }
        message = json["message"].stringValue
        success = json["success"].boolValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if data != nil{
            var dictionaryElements = [[String:Any]]()
            for dataElement in data {
                dictionaryElements.append(dataElement.toDictionary())
            }
            dictionary["data"] = dictionaryElements
        }
        if message != nil{
            dictionary["message"] = message
        }
        if success != nil{
            dictionary["success"] = success
        }
        return dictionary
    }
}



class TodoData{
    
    var dateTime : String!
    var dept : UCN!
    var executeId : String!
    var executeNo : String!
    var state : String!
    var uuid : String!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        dateTime = json["dateTime"].stringValue
        let deptJson = json["dept"]
        if !deptJson.isEmpty{
            dept = UCN(fromJson: deptJson)
        }
        executeId = json["executeId"].stringValue
        executeNo = json["executeNo"].stringValue
        state = json["state"].stringValue
        uuid = json["uuid"].stringValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if dateTime != nil{
            dictionary["dateTime"] = dateTime
        }
        if dept != nil{
            dictionary["dept"] = dept.toDictionary()
        }
        if executeId != nil{
            dictionary["executeId"] = executeId
        }
        if executeNo != nil{
            dictionary["executeNo"] = executeNo
        }
        if state != nil{
            dictionary["state"] = state
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        return dictionary
    }
    
}
