//
//  RepairOrderViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/3.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import Moya

class RepairOrderViewModel: BaseViewModel {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    
    /// 查询工单列表对象
    lazy final var queryModel: RepairOrderQueryModel = {
        var queryModel = RepairOrderQueryModel()
        queryModel.startCreateTime = NSDate(after: Date(), day: -7).httpParameterString()
        queryModel.endCreateTime = NSDate().httpParameterString()
        queryModel.pageSize = kPageSize
        queryModel.page = kZERO
        return queryModel
    }()
    
    /// 工单列表数据
    lazy final var repairOrderArray: Array<RepairOrderRecord> = {
        var repairOrderArray = Array<RepairOrderRecord>()
        return repairOrderArray
    }()
    
    /// 过滤ViewModel
    lazy final var filterViewModel: FilterViewModel = {
        var filterViewModel = FilterViewModel()
        return filterViewModel
    }()
}

extension RepairOrderViewModel {

    /// 查询工单列表
    func queryRepairOrderAction() ->Observable<Int> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .QueryRepairOrder(self.queryModel), success: {[weak self] (json) in
                let resultModel = RepairOrderResultModel(fromJson: json)
                if resultModel.success {
                    if self?.queryModel.page == kZERO {
                        self?.repairOrderArray.removeAll()
                    }
                    for model in resultModel.data.records {
                        self?.repairOrderArray.append(model)
                    }
                    observer.onNext(resultModel.data.paging.pageCount)
                }else {
                    ShowMessage(resultModel.message)
                    observer.onError(MoyaError.requestMapping(resultModel.message))
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
                observer.onError(MoyaError.requestMapping(error.localizedDescription))
            })
            return Disposables.create()
        })
    }
}

extension RepairOrderViewModel {
    
    // MARK: - 创建工单列表cell
    func dequeueReusableCell(_ identifier: String,_ tableView: UITableView,_ indexPath: IndexPath) -> UITableViewCell {
        let billCell = tableView.dequeueReusableCell(withIdentifier: identifier, for: indexPath) as! RepairOrderTableViewCell
        billCell.updateBillCell(repairOrderArray[indexPath.row], indexPath)
        return billCell
    }
    
    // MARK: - 工单列表筛选数据
    // 时间、状态、来源、优先级
    func repairOrderFilterBtnAction(_ sender: UIButton) ->Observable<Void> {
        return Observable.create({[weak self] (observer) -> Disposable in
            switch sender.tag {
            case REPAIR_ORDER_FILTER_BUTTON_TAG.TIME.rawValue:
                YXPickerManager.share().showGeneralPickerView(kNavColor, dataArray: ["最近一周","最近一个月","最近三个月","最近半年","最近一年"], defaultString: sender.currentTitle, commit: { (text, index) in
                    sender.isSelected = false
                    sender.addBorder(1.0, kGaryColor)
                    sender.setTitle(text, for: .normal)
                    sender.horizontalCenterTitleAndImage(5)
                    var afterDay: Int = -7
                    switch index {
                    case 0:
                        afterDay = -7
                        break
                    case 1:
                        afterDay = -30
                        break
                    case 2:
                        afterDay = -90
                        break
                    case 3:
                        afterDay = -6 * 30
                        break
                    case 2:
                        afterDay = -12 * 30
                        break
                    default:
                        break
                    }
                    self?.queryModel.startCreateTime = NSDate(after: Date(), day: afterDay).httpParameterString()
                    self?.queryModel.endCreateTime = NSDate().httpParameterString()
                    observer.onNext(())
                }, cancel: {
                    sender.isSelected = false
                    sender.addBorder(1.0, kGaryColor)
                })
                break
            case REPAIR_ORDER_FILTER_BUTTON_TAG.STATE.rawValue:
                YXPickerManager.share().showGeneralPickerView(kNavColor, dataArray: ["全部状态","未发出","已发出","处理中","已完成","已删除","已作废"], defaultString: sender.currentTitle, commit: { (text, index) in
                    sender.isSelected = false
                    sender.addBorder(1.0, kGaryColor)
                    sender.setTitle(text, for: .normal)
                    sender.horizontalCenterTitleAndImage(5)
                    if index == kZERO {
                        self?.queryModel.state = nil
                    }else {
                        self?.queryModel.state = repairOrderEnglishState(text!)
                    }
                    observer.onNext(())
                }, cancel: {
                    sender.isSelected = false
                    sender.addBorder(1.0, kGaryColor)
                })
                break
            case REPAIR_ORDER_FILTER_BUTTON_TAG.SOURCE.rawValue:
                self?.filterViewModel.queryProjectSponsors().subscribe(onNext: { (result) in
                    let array = NSMutableArray(array: result)
                    array.insert("全部来源", at: kZERO)
                    YXPickerManager.share().showGeneralPickerView(kNavColor, dataArray: array as! [String], defaultString: sender.currentTitle, commit: { (text, index) in
                        sender.isSelected = false
                        sender.addBorder(1.0, kGaryColor)
                        sender.setTitle(text, for: .normal)
                        sender.horizontalCenterTitleAndImage(5)
                        if index == kZERO {
                            self?.queryModel.source = nil
                        }else {
                            self?.queryModel.source = text
                        }
                        observer.onNext(())
                    }, cancel: {
                        sender.isSelected = false
                        sender.addBorder(1.0, kGaryColor)
                    })
                }).disposed(by: self!.disposeBag)
                break
            case REPAIR_ORDER_FILTER_BUTTON_TAG.PRIORITY.rawValue:
                self?.filterViewModel.queryProrityOption().subscribe(onNext: {[weak self] (result) in
                    let array = NSMutableArray(array: result)
                    array.insert("全部优先级", at: kZERO)
                    YXPickerManager.share().showGeneralPickerView(kNavColor, dataArray: array as! [String], defaultString: sender.currentTitle, commit: { (text, index) in
                        sender.isSelected = false
                        sender.addBorder(1.0, kGaryColor)
                        sender.setTitle(text, for: .normal)
                        sender.horizontalCenterTitleAndImage(5)
                        if index == kZERO {
                            self?.queryModel.level = nil
                        }else {
                            self?.queryModel.level = text
                        }
                        observer.onNext(())
                    }, cancel: {
                        sender.isSelected = false
                        sender.addBorder(1.0, kGaryColor)
                    })
                }).disposed(by: self!.disposeBag)
                break
            default:
                break
            }
            return Disposables.create()
        })
    }
}




















