//
//  RepairOrderAddViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/11.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift

class RepairOrderAddViewModel: BaseViewModel {
    
    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    
    /// 过滤ViewModel
    lazy final var filterViewModel: FilterViewModel = {
        var filterViewModel = FilterViewModel()
        return filterViewModel
    }()
    
    /// 提交工单model
    lazy final var saveOrderModel: SaveRepairOrderModel = {
        var saveOrderModel = SaveRepairOrderModel()
        return saveOrderModel
    }()
}

extension RepairOrderAddViewModel {
    
    // MARK: - 是否允许提交工单
    func repairOrderAvailable(_ sender: UISwitch) ->Bool {
        guard saveOrderModel.store != nil else {
            ShowMessage("请选择项目")
            return false
        }
        guard saveOrderModel.source != nil else {
            ShowMessage("请选择工单来源")
            return false
        }
        guard saveOrderModel.serviceType != nil else {
            ShowMessage("请选择工单服务类型")
            return false
        }
        guard saveOrderModel.level != nil else {
            ShowMessage("请选择工单优先级")
            return false
        }
        guard saveOrderModel.reportUser != nil else {
            ShowMessage("请选择工单报事人")
            return false
        }
        guard saveOrderModel.receiveTime != nil else {
            ShowMessage("请选择工单接报时间")
            return false
        }
        guard saveOrderModel.requestTime != nil else {
            ShowMessage("请选择工单指定时间")
            return false
        }
        guard NSString(string: saveOrderModel.reporterPhone).isTelephone() != false else {
            ShowMessage("报事人电话格式不正确")
            return false
        }
        guard saveOrderModel.position != nil else {
            ShowMessage("请选择工单指定位置")
            return false
        }
        guard saveOrderModel.position != nil else {
            ShowMessage("请选择工单指定位置")
            return false
        }
        if sender.isOn {
            guard saveOrderModel.device != nil else {
                ShowMessage("请选择故障设施")
                return false
            }
            guard saveOrderModel.brokenTime != nil else {
                ShowMessage("请选择设施故障时间")
                return false
            }
        }
        return true
    }
    
    // MARK: - 提交工单
    func submitRepairOrder() ->Observable<String> {
        saveOrderModel.state = SUBMIT_REPAIR_ORDER_STATE.SUBMIT.rawValue
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .SubmitOrder(self.saveOrderModel), success: { (json) in
                let resultModel = PublicResultModel(fromJson: json)
                if resultModel.success {
                    observer.onNext(resultModel.data)
                }else {
                    ShowMessage(resultModel.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
}

extension RepairOrderAddViewModel {
    // MARK: - 选择Item
    func didSelectRowAtIndePath(_ indexPath: IndexPath, _ controller: RepairOrderAddTableViewController) {
        switch indexPath {
        case IndexPath(row: 0, section: 0):
            filterViewModel.queryProjectType().subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                let publicFilterVc = FilterViewController.instantiateViewController(.Function) as! FilterViewController
                for model in result {
                    let filterModel: PublicFilterModel?
                    if model.name == controller.projectLabel.text {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kONE)")
                    }else {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kZERO)")
                    }
                    publicFilterVc.publicViewModel.filterArray.add(filterModel!)
                }
                controller.pushVC(publicFilterVc)
                publicFilterVc.setNavigationTitle("筛选项目",.SINGLE, { (choices, index) in
                    let choiceModel = choices.first!
                    controller.projectLabel.text = choiceModel.title
                    controller.projectLabel.textColor = kBlackColor
                    let model = result[index!]
                    let user = UCN(model.code, model.name, model.uuid)
                    self?.saveOrderModel.store = user
                })
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 1, section: 0):
            filterViewModel.queryProjectSponsors().subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                YXPickerManager.share().showGeneralPickerView(kMainColor, dataArray: result, defaultString: controller.sourceLabel.text, commit: { (text, index) in
                    controller.sourceLabel.text = text
                    controller.sourceLabel.textColor = kBlackColor
                    self?.saveOrderModel.source = text
                    if text == "租区" {
                        NotificationCenter.default.post(name: NSNotification.Name(rawValue: UPDATE_REPAIRORDER_ADD_LIST), object: REPAIRORDER_STORE.SHOW.rawValue)
                    }else {
                        self?.saveOrderModel.tenant = nil
                        controller.tenantLabel.text = nil
                        NotificationCenter.default.post(name: NSNotification.Name(rawValue: UPDATE_REPAIRORDER_ADD_LIST), object: REPAIRORDER_STORE.HIDE.rawValue)
                    }
                }, cancel: nil)
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 2, section: 0):
            if saveOrderModel.store == nil {
                ShowMessage("请先选择项目")
                return
            }
            let model = QueryModel()
            model.storeUuidEquals = saveOrderModel.store.uuid
            filterViewModel.queryTenant(model).subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                let publicFilterVc = FilterViewController.instantiateViewController(.Function) as! FilterViewController
                for model in result {
                    let filterModel: PublicFilterModel?
                    if model.name == controller.tenantLabel.text {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kONE)")
                    }else {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kZERO)")
                    }
                    publicFilterVc.publicViewModel.filterArray.add(filterModel!)
                }
                controller.pushVC(publicFilterVc)
                publicFilterVc.setNavigationTitle("筛选项目",.SINGLE, { (choices, index) in
                    let choiceModel = choices.first!
                    controller.tenantLabel.text = choiceModel.title
                    controller.tenantLabel.textColor = kBlackColor
                    let model = result[index!]
                    let tenant = UCN(model.code, model.name, model.uuid)
                    self?.saveOrderModel.tenant = tenant
                })
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 3, section: 0):
            filterViewModel.queryServerType().subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                YXPickerManager.share().showGeneralPickerView(kMainColor, dataArray: result, defaultString: controller.serviceTypeLabel.text, commit: { (text, index) in
                    controller.serviceTypeLabel.text = text
                    controller.serviceTypeLabel.textColor = kBlackColor
                    self?.saveOrderModel.serviceType = text
                }, cancel: nil)
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 4, section: 0):
            filterViewModel.queryProrityOption().subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                YXPickerManager.share().showGeneralPickerView(kMainColor, dataArray: result, defaultString: controller.priorityLabel.text, commit: { (text, index) in
                    controller.priorityLabel.text = text
                    controller.priorityLabel.textColor = kBlackColor
                    self?.saveOrderModel.level = text
                }, cancel: nil)
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 5, section: 0):
            if saveOrderModel.store == nil {
                ShowMessage("请先选择项目")
                return
            }
            let model = QueryModel()
            model.storeUuidEquals = saveOrderModel.store.uuid
            filterViewModel.queryInitiator(model).subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                let publicFilterVc = FilterViewController.instantiateViewController(.Function) as! FilterViewController
                for model in result {
                    let filterModel: PublicFilterModel?
                    if model.name == controller.originatorLabel.text {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kONE)")
                    }else {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kZERO)")
                    }
                    publicFilterVc.publicViewModel.filterArray.add(filterModel!)
                }
                controller.pushVC(publicFilterVc)
                publicFilterVc.setNavigationTitle("筛选报事人",.SINGLE, { (choices, index) in
                    let choiceModel = choices.first!
                    let model = result[index!]
                    controller.originatorLabel.text = choiceModel.title
                    controller.phoneNumberText.text = model.mobile
                    self?.saveOrderModel.reporterPhone = model.mobile
                    controller.originatorLabel.textColor = kBlackColor
                    let user = UCN(model.login, model.name, model.uuid)
                    self?.saveOrderModel.reportUser = user
                })
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 7, section: 0):
            let defaultDate = controller.originatorTimeLabel.text == "工单接报时间" ? NSDate().httpParameterString() : controller.originatorTimeLabel.text
            var date: Date?
            if saveOrderModel.requestTime != nil {
                date = Date(fromString: saveOrderModel.requestTime, format: "yyyy-MM-dd HH:mm:ss")!
            }
            YXPickerManager.share().showDatePickerView(kMainColor, datePickerModel: UIDatePickerMode.dateAndTime, minimumDate: Date(), maximumDate: date, defaultDate: defaultDate, commit: {[weak self] (time) in
                controller.originatorTimeLabel.text = time
                controller.originatorTimeLabel.textColor = kBlackColor
                self?.saveOrderModel.receiveTime = time
            }, cancel: nil)
            break
        case IndexPath(row: 8, section: 0):
            let defaultDate = controller.specifiedTimeLabel.text == "工单指定时间" ? NSDate().httpParameterString() : controller.originatorTimeLabel.text
            var date = Date()
            if saveOrderModel.receiveTime != nil {
                date = Date(fromString: saveOrderModel.receiveTime, format: "yyyy-MM-dd HH:mm:ss")!
            }
            YXPickerManager.share().showDatePickerView(kMainColor, datePickerModel: UIDatePickerMode.dateAndTime, minimumDate: date, maximumDate: nil, defaultDate: defaultDate, commit: {[weak self] (time) in
                controller.specifiedTimeLabel.text = time
                controller.specifiedTimeLabel.textColor = kBlackColor
                self?.saveOrderModel.requestTime = time
            }, cancel: nil)
            break
        case IndexPath(row: 9, section: 0):
            if saveOrderModel.store == nil {
                ShowMessage("请先选择项目")
                return
            }
            let model = QueryModel()
            model.storeUuidEquals = saveOrderModel.store.uuid
            filterViewModel.queryLocation(model).subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                let publicFilterVc = FilterViewController.instantiateViewController(.Function) as! FilterViewController
                for model in result {
                    let filterModel: PublicFilterModel?
                    if model.name == controller.specifiedLocationLabel.text {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kONE)")
                    }else {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kZERO)")
                    }
                    publicFilterVc.publicViewModel.filterArray.add(filterModel!)
                }
                controller.pushVC(publicFilterVc)
                publicFilterVc.setNavigationTitle("筛选位置",.SINGLE, { (choices, index) in
                    let choiceModel = choices.first!
                    controller.specifiedLocationLabel.text = choiceModel.title
                    controller.specifiedLocationLabel.textColor = kBlackColor
                    let model = result[index!]
                    let location = UCN(model.code, model.name, model.uuid)
                    self?.saveOrderModel.position = location
                })
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 10, section: 0):
            if saveOrderModel.locationAttachmentId != nil {
                ShowAlertView(hint, "请选择操作类型", ["取消","重新编辑","查看"], .actionSheet, {[weak self] (index) in
                    switch index {
                    case 0:
                        break
                    case 1:
                        self?.editImage(controller)
                        break
                    case 2:
                        let editVc = EditImageViewController()
                        editVc.type = .VIEW
                        editVc.imageString = self?.saveOrderModel.locationAttachmentUrl
                        controller.pushVC(editVc)
                        break
                    default:
                        break
                    }
                })
            }else {
                editImage(controller)
            }
            break
        case IndexPath(row: 0, section: 1):
            if saveOrderModel.store == nil {
                ShowMessage("请先选择项目")
                return
            }
            let model = DeviceQueryModel()
            model.storeIdEquals = saveOrderModel.store.uuid
            filterViewModel.queryDevice(model).subscribe(onNext: {[weak self] (result) in
                if result.isEmpty {
                    ShowMessage("无数据")
                    return
                }
                let publicFilterVc = FilterViewController.instantiateViewController(.Function) as! FilterViewController
                for model in result {
                    let filterModel: PublicFilterModel?
                    if model.name == controller.deviceTitleLabel.text {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kONE)")
                    }else {
                        filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kZERO)")
                    }
                    publicFilterVc.publicViewModel.filterArray.add(filterModel!)
                }
                publicFilterVc.setNavigationTitle("筛选设施",.SINGLE, { (choices, index) in
                    let deviceModel = result[index!]
                    let choiceModel = choices.first!
                    controller.deviceTitleLabel.text = choiceModel.title
                    controller.deviceLocationLabel.text = deviceModel.location
                    controller.deviceTitleLabel.textColor = kBlackColor
                    controller.deviceLocationLabel.textColor = kBlackColor
                    let device = UCN(deviceModel.code, deviceModel.name, deviceModel.uuid)
                    self?.saveOrderModel.device = device
                    self?.saveOrderModel.deviceadree = deviceModel.location
                })
                controller.pushVC(publicFilterVc)
            }).disposed(by: disposeBag)
            break
        case IndexPath(row: 2, section: 1):
            let defaultDate = controller.deviceFaultTimeLabel.text == "设施故障时间" ? NSDate().httpParameterString() : controller.deviceFaultTimeLabel.text
            YXPickerManager.share().showDatePickerView(kMainColor, datePickerModel: UIDatePickerMode.dateAndTime, minimumDate: nil, maximumDate: nil, defaultDate: defaultDate, commit: {[weak self] (time) in
                controller.deviceFaultTimeLabel.text = time
                controller.deviceFaultTimeLabel.textColor = kBlackColor
                self?.saveOrderModel.brokenTime = time
            }, cancel: nil)
            break
        default:
            break
        }
    }
    
    
    /// 编辑图片
    func editImage(_ controller: RepairOrderAddTableViewController) {
        let model = FlooryuQueryModel()
        model.storeUuidEquals = AppManager.shareInstance.userStoreModel?.uuid
        model.stateEquals = true
        model.page = kZERO
        model.pageSize = kZERO
        filterViewModel.queryFlooryu(model).subscribe(onNext: {[weak self] (result) in
            if result.isEmpty {
                ShowMessage("无数据")
                return
            }
            let publicFilterVc = FilterViewController.instantiateViewController(.Function) as! FilterViewController
            for model in result {
                let filterModel: PublicFilterModel?
                if model.name == controller.specifiedLocationLabel.text {
                    filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kONE)")
                }else {
                    filterModel = PublicFilterModel(uuid: model.uuid, title: model.name, isSelected: "\(kZERO)")
                }
                publicFilterVc.publicViewModel.filterArray.add(filterModel!)
            }
            controller.pushVC(publicFilterVc)
            publicFilterVc.setNavigationTitle("筛选楼宇",.SINGLE, { (choices, index) in
                let choiceModel = choices.first!
                self?.filterViewModel.queryFloorlayer(choiceModel.uuid!).subscribe(onNext: { (result) in
                    if result.isEmpty {
                        self?.saveOrderModel.locationAttachmentId = nil
                        self?.saveOrderModel.locationAttachmentUrl = nil
                        ShowMessage("无楼层数据")
                        return
                    }
                    let editVc = EditImageViewController()
                    editVc.type = .EDIT
                    editVc.imageArray = result
                    controller.pushVC(editVc)
                    editVc.setSaveImageBlock({ (imageUrl) in
                        controller.specifiedLocationImg.image = UIImage(contentsOfFile: imageUrl)
                        self?.saveOrderModel.locationAttachmentId = controller.randomMD5()
                        self?.saveOrderModel.locationAttachmentUrl = imageUrl
                    })
                }).disposed(by: self!.disposeBag)
            })
        }).disposed(by: disposeBag)
    }
}
