//
//  RepairOrderSubOrderTableViewCell.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/8.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class RepairOrderSubOrderTableViewCell: UITableViewCell {

    
    
    /// 部门
    @IBOutlet weak var departmentName: UILabel!
    /// 转交时间
    @IBOutlet weak var transferTimeLabel: UILabel!
    /// 工单状态
    @IBOutlet weak var subOrderState: UILabel!
    /// 内容背景
    @IBOutlet weak var contentBgView: UIView!
    
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        uiConfigAction()
    }

    // MARK: - UI
    fileprivate func uiConfigAction() {
        contentBgView.addAngle(10.0)
        contentBgView.addBorder(1.0, kGaryColor)
        selectedBackgroundView = UIView()
        selectedBackgroundView?.backgroundColor = UIColor.clear
    }
    
    // MARK: - 更新子工单cell
    func updateChildBillCell(_ model: BillDetailExecute, _ indexPath: IndexPath) {
        departmentName.text = model.dept.name
        transferTimeLabel.text = model.lastModifyTime
        subOrderState.text = repairOrderChineseState(model.state)
    }
}
















