//
//  RepairOrderDetailSuspendView.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/8.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class RepairOrderDetailSuspendView: UIView {

    /// 内容背景
    @IBOutlet weak var contentBgView: UIView!
    /// 操作工单(领单、完成)
    @IBOutlet weak var operationOrderBtn: UIButton!
    /// 工单状态
    @IBOutlet weak var orderStateLab: UILabel!
    /// 部门
    @IBOutlet weak var departmentLab: UILabel!
    /// 转交时间
    @IBOutlet weak var operationTimeLab: UILabel!
    
    /// 数据源
    var model: BillDetailExecute!
    
    /// 悬浮框对应数据下标
    var indexPath: IndexPath!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        uiConfigAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        addShadow(UIColor.black)
        contentBgView.addAngle(5.0)
    }
    
    // MARK: - 更新悬浮框
    func updateSuspendView(_ model: BillDetailExecute, _ indexPath: IndexPath) {
        self.model = model
        self.indexPath = indexPath
        orderStateLab.text = repairOrderChineseState(model.state)
        operationTimeLab.text = model.lastModifyTime
        departmentLab.text = model.dept.name
        switch model.state {
        case SUBMIT_REPAIR_ORDER_STATE.INIT.rawValue:
            operationOrderBtn.setTitle(SUSPEND_BUTTON_TYPE.GET.rawValue, for: .normal)
            operationOrderBtn.backgroundColor = kBlueColor
            break
        case SUBMIT_REPAIR_ORDER_STATE.DREW.rawValue:
            operationOrderBtn.setTitle(SUSPEND_BUTTON_TYPE.COMPLETED.rawValue, for: .normal)
            operationOrderBtn.backgroundColor = kYellowColor
            break
        default:
            break
        }
    }
}








