//
//  PhotoAttachmentModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/3.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

struct PhotoAttachmentModel<T> {
    
    /// 图片附件类型
    var attachmentType: ATTACHMENT_LOCATION
    /// 附件
    /// 如果是网络地址则为图片http地址
    /// 如果是本地图片则为image
    /// 如果是新增附件则为imageName
    var attachment: T
    var entityType: String!
    var entityUuid: String!
    
    init(_ attachment: T, _ type: ATTACHMENT_LOCATION) {
        self.attachment = attachment
        self.attachmentType = type
    }
    
    init(_ attachment: T,_ entityType: String, _ entityUuid: String, _ type: ATTACHMENT_LOCATION) {
        self.attachment = attachment
        self.attachmentType = type
        self.entityType = entityType
        self.entityUuid = entityUuid
    }
}


/// 附件上传Model
public struct UploadPhotoAttachmentModel {
    
    var entityType: String
    var fileUrl: String
    var fileName: String
    var entityUuid: String
    
    init(_ fileName: String, _ fileUrl: String, _ entityType: String, _ entityUuid: String) {
        self.fileName = fileName
        self.fileUrl = fileUrl
        self.entityType = entityType
        self.entityUuid = entityUuid
    }
}














