//
//  RepairOrderChildBillDetailViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/8.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxSwift
import RxCocoa

class RepairOrderChildBillDetailViewController: BaseTableViewController {

    /// 已发出状态
    @IBOutlet weak var createdStateImg: UIImageView!
    @IBOutlet weak var createStateLab: UILabel!
    /// 处理中状态
    @IBOutlet weak var processedStateImg: UIImageView!
    @IBOutlet weak var processedStateLab: UILabel!
    /// 已完成状态
    @IBOutlet weak var completedStateImg: UIImageView!
    @IBOutlet weak var completedStateLab: UILabel!
    
    /// 领单人
    @IBOutlet weak var operatorNameLabel: UILabel!
    /// 单号
    @IBOutlet weak var billNumberLab: UILabel!
    /// 领单时间
    @IBOutlet weak var billNumberTimeLabel: UILabel!
    /// 备份工具
    @IBOutlet weak var backupsToolLabel: UILabel!
    /// 安全防护
    @IBOutlet weak var safetyProtectionLabel: UILabel!
    /// 出工人
    @IBOutlet weak var workPersonLabel: UILabel!
    /// 到位时间
    @IBOutlet weak var placeTimeLabel: UILabel!
    /// 离开时间
    @IBOutlet weak var leaveTimeLabel: UILabel!
    /// 故障原因
    @IBOutlet weak var failureCauseLabel: UILabel!
    /// 处理方式
    @IBOutlet weak var processModeLabel: UILabel!
    /// 人工费
    @IBOutlet weak var costLaborLabel: UILabel!
    /// 物料费用
    @IBOutlet weak var materialCostLabel: UILabel!
    /// 描述
    @IBOutlet weak var describeLabel: UILabel!
    /// 设备名称
    @IBOutlet weak var deviceNameLabel: UILabel!
    
    /// 附件宽度
    let imageWidth = ((kWidth - 90) - CGFloat((3 + kONE) * 5)) / 3
    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 默认section高度
    let sectionHeight: CGFloat! = 30
    /// 维修前图片附件高度
    var beforAttachmentHeight: CGFloat! = 10
    /// 维修后图片附件高度
    var afterAttachmentHeight: CGFloat! = 10
    /// 工单数据
    open var billModel: BillDetailExecute!
    /// 维修前图片附件
    lazy final var beforAttachmentVc: PhotoAttachmentViewController = {
        var attachmentVc = PhotoAttachmentViewController.instantiateViewController(.Function) as! PhotoAttachmentViewController
        return attachmentVc
    }()
    
    /// 维修后图片附件
    lazy final var afterAttachmentVc: PhotoAttachmentViewController = {
        var attachmentVc = PhotoAttachmentViewController.instantiateViewController(.Function) as! PhotoAttachmentViewController
        return attachmentVc
    }()
    
    /// 子工单详情ViewModel
    lazy final var childBillViewModel: ReparirChildBillViewModel = {
        var childBillViewModel = ReparirChildBillViewModel()
        return childBillViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        getBillDetailAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        title = String(format: "%@工单详情", billModel.dept.name)
        tableView.register(UINib(nibName: RepairOrderDetailSectionView.name(), bundle: nil), forHeaderFooterViewReuseIdentifier: RepairOrderDetailSectionView.name())
        tableView.register(UINib(nibName: MaintainBeforAttachmentTableViewCell.name(), bundle: nil), forCellReuseIdentifier: MaintainBeforAttachmentTableViewCell.name())
        tableView.register(UINib(nibName: MaintainAfterAttachmentTableViewCell.name(), bundle: nil), forCellReuseIdentifier: MaintainAfterAttachmentTableViewCell.name())
        tableView.register(UINib(nibName: CostOrBorrowTableViewCell.name(), bundle: nil), forCellReuseIdentifier: CostOrBorrowTableViewCell.name())
        addChildViewController(afterAttachmentVc)
        addChildViewController(beforAttachmentVc)
    }
    
    // MARK: - 获取子工单详情
    fileprivate func getBillDetailAction() {
        childBillViewModel.queryChildBillDetailAction(billModel.uuid).subscribe {[weak self] (event) in
            self?.childBillViewModel.childBillDetailAssignment(self!)
            self?.childBillViewModel.billDetailStataDispose(self!)
            self?.disposeAttachment()
            self?.tableView.reloadData()
            }.disposed(by: disposeBag)
    }
    
    // MARK: - 获取图片附件通过entity uuid
    fileprivate func disposeAttachment() {
        if !childBillViewModel.childBillDetailData.beginAttachmentId.isEmpty {
            childBillViewModel.downloadBeforAttachmentAction(childBillViewModel.childBillDetailData.beginAttachmentId)
                .subscribe(onNext: {[weak self] (result) in
                    for model in result {
                        let url = String(format: attachmentUrl, model.entityType,model.entityUuid,model.fileName)
                        self?.beforAttachmentVc.attachmentViewModel.photoAttachments.insert(PhotoAttachmentModel(url, ATTACHMENT_TYPE.CHILD_BILL_ATTACHMENT_TYPE.rawValue, model.entityUuid, ATTACHMENT_LOCATION.ATTACHMENT_HTTP), at: kZERO)
                    }
                    if result.count > kZERO {
                        self?.beforAttachmentVc.setItemSize(CGSize(width: self!.imageWidth, height: self!.imageWidth),3)
                        self?.beforAttachmentHeight = self?.beforAttachmentVc.attachmentHeight(result.count,befor)
                        self?.tableView.reloadData()
                    }
                }).disposed(by: disposeBag)
        }
        if !childBillViewModel.childBillDetailData.endAttachmentId.isEmpty {
            childBillViewModel.downloadAafterAttachmentAction(childBillViewModel.childBillDetailData.endAttachmentId)
                .subscribe(onNext: {[weak self] (result) in
                    for model in result {
                        let url = String(format: attachmentUrl, model.entityType,model.entityUuid,model.fileName)
                        self?.afterAttachmentVc.attachmentViewModel.photoAttachments.insert(PhotoAttachmentModel(url, ATTACHMENT_TYPE.CHILD_BILL_ATTACHMENT_TYPE.rawValue, model.entityUuid, ATTACHMENT_LOCATION.ATTACHMENT_HTTP), at: kZERO)
                    }
                    if result.count > kZERO {
                        self?.afterAttachmentVc.setItemSize(CGSize(width: self!.imageWidth, height: self!.imageWidth),3)
                        self?.afterAttachmentHeight = self?.afterAttachmentVc.attachmentHeight(result.count,after)
                        self?.tableView.reloadData()
                    }
                }).disposed(by: disposeBag)
        }
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.section == CHILD_BILL_DETAIL_SECTION.DESCRIBE.rawValue {
            if indexPath.row == kONE {
                let beforCell = tableView.dequeueReusableCell(withIdentifier: MaintainBeforAttachmentTableViewCell.name(), for: indexPath)
                beforAttachmentVc.view.frame = CGRect(x: 80, y: 0, width: kWidth - 90, height: beforAttachmentHeight)
                beforCell.contentView.addSubview(beforAttachmentVc.view)
                beforAttachmentVc.photoAttachmentCollectionView.reloadData()
                return beforCell
            }
            if indexPath.row == kONE * 2 {
                let afterCell = tableView.dequeueReusableCell(withIdentifier: MaintainAfterAttachmentTableViewCell.name(), for: indexPath)
                afterAttachmentVc.view.frame = CGRect(x: 80, y: 0, width: kWidth - 90, height: afterAttachmentHeight)
                afterCell.contentView.addSubview(afterAttachmentVc.view)
                afterAttachmentVc.photoAttachmentCollectionView.reloadData()
                return afterCell
            }
        }
        if indexPath.section == CHILD_BILL_DETAIL_SECTION.COST.rawValue {
            if indexPath.row != kZERO {
                let costCell = tableView.dequeueReusableCell(withIdentifier: CostOrBorrowTableViewCell.name(), for: indexPath) as! CostOrBorrowTableViewCell
                let model = childBillViewModel.childBillDetailData.executeOutsources[indexPath.row - kONE]
                costCell.updateCell(model, indexPath)
                return costCell
            }
        }
        if indexPath.section == CHILD_BILL_DETAIL_SECTION.BORROW.rawValue {
            if indexPath.row != kZERO {
                let brrowCell = tableView.dequeueReusableCell(withIdentifier: CostOrBorrowTableViewCell.name(), for: indexPath) as! CostOrBorrowTableViewCell
                let model = childBillViewModel.childBillDetailData.executeMateriels[indexPath.row - kONE]
                brrowCell.updateCell(model, indexPath)
                return brrowCell
            }
        }
        return super.tableView(tableView, cellForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return kSectionZero
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        if section == CHILD_BILL_DETAIL_SECTION.STATE.rawValue {
            return kSectionZero
        }
        return 35
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        switch section {
        case CHILD_BILL_DETAIL_SECTION.COST.rawValue:
            if childBillViewModel.childBillDetailData.executeOutsources == nil {
                return kONE
            }
            return childBillViewModel.childBillDetailData.executeOutsources.count + kONE
        case CHILD_BILL_DETAIL_SECTION.BORROW.rawValue:
            if childBillViewModel.childBillDetailData.executeMateriels == nil {
                return kONE
            }
            return childBillViewModel.childBillDetailData.executeMateriels.count + kONE
        case CHILD_BILL_DETAIL_SECTION.DESCRIBE.rawValue:
            return 3
        default:
            break
        }
        return super.tableView(tableView, numberOfRowsInSection: section)
    }
    
    override func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        if section == CHILD_BILL_DETAIL_SECTION.STATE.rawValue {
            return UIView()
        }
        return childBillViewModel.dequeueReusableHeaderFooterView(RepairOrderDetailSectionView.name(),tableView,section)
    }
    
    //cell的缩进级别，动态静态cell必须重写，否则会造成崩溃
    override func tableView(_ tableView: UITableView, indentationLevelForRowAt indexPath: IndexPath) -> Int {
        switch indexPath.section {
        case CHILD_BILL_DETAIL_SECTION.COST.rawValue:
            return super.tableView(tableView, indentationLevelForRowAt: IndexPath(row: 0, section: CHILD_BILL_DETAIL_SECTION.COST.rawValue))
        case CHILD_BILL_DETAIL_SECTION.BORROW.rawValue:
            return super.tableView(tableView, indentationLevelForRowAt: IndexPath(row: 0, section: CHILD_BILL_DETAIL_SECTION.BORROW.rawValue))
        default:
            break
        }
        return super.tableView(tableView, indentationLevelForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.section == CHILD_BILL_DETAIL_SECTION.DESCRIBE.rawValue {
            if indexPath.row == kZERO {
                return childBillViewModel.childBillDetailData.noteHeight + 30
            }
            if indexPath.row == kONE {
                return beforAttachmentHeight + 15
            }
            if indexPath.row == kONE * 2 {
                return afterAttachmentHeight + 15
            }
        }
        if indexPath.section == CHILD_BILL_DETAIL_SECTION.COST.rawValue || indexPath.section == CHILD_BILL_DETAIL_SECTION.BORROW.rawValue {
            if indexPath.row == kZERO {
                return 30
            }
            return kCellHeight
        }
        return super.tableView(tableView, heightForRowAt: indexPath)
    }
    
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        switch indexPath.section {
        case CHILD_BILL_DETAIL_SECTION.COST.rawValue:
            if indexPath.row == kZERO {
                return
            }
            let costVc = ChildBillDetailCostViewController.instantiateViewController(.Function) as! ChildBillDetailCostViewController
            costVc.costModel = childBillViewModel.childBillDetailData.executeOutsources[indexPath.row - kONE]
            pushVC(costVc)
            break
        case CHILD_BILL_DETAIL_SECTION.BORROW.rawValue:
            if indexPath.row == kZERO {
                return
            }
            let borrowVc = ChildBillDetailBorrowViewController.instantiateViewController(.Function) as! ChildBillDetailBorrowViewController
            borrowVc.borrowModel = childBillViewModel.childBillDetailData.executeMateriels[indexPath.row - kONE]
            pushVC(borrowVc)
            break
        default:
            break
        }
    }
}















