//
//  ChildBillDetailBorrowViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/3/12.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class ChildBillDetailBorrowViewController: BaseTableViewController {

    /// 设备
    @IBOutlet weak var deviceLabel: UILabel!
    /// 借用单单号
    @IBOutlet weak var orderNumberLabel: UILabel!
    /// 借用数量
    @IBOutlet weak var extractCountLabel: UILabel!
    /// 归回数量
    @IBOutlet weak var returnCountLabel: UILabel!
    
    open var borrowModel: ExecuteMateriel!

    override func viewDidLoad() {
        super.viewDidLoad()

        setupDataAction()
    }
    
    // MARK: - 设置数据源
    fileprivate func setupDataAction() {
        deviceLabel.text = borrowModel.materiel.name
        orderNumberLabel.text = borrowModel.outputbillno
        extractCountLabel.text = String(format: "%.0f", borrowModel.getQty)
        returnCountLabel.text = String(format: "%.0f", borrowModel.useQty)
    }
    
    override func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return kSectionTen
    }
}
