//
//  FunctionViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class FunctionViewModel: BaseViewModel {

    // MARK: - 功能菜单图片
    lazy final var itemArrays: Array<FunctionModel> = {
        var itemImgArrays = Array<FunctionModel>()
        let plistpath = Bundle.main.path(forResource: "function", ofType: "plist")
        let tempArrays = NSArray(contentsOfFile: plistpath!)
        for object in tempArrays! {
            let dict = object as! Dictionary<String, String>
            let model = FunctionModel(item_name: dict["item_name"]!, item_image: dict["item_image"]!,permissions: dict["permissions"]!)
            itemImgArrays.append(model)
        }
        return itemImgArrays
    }()
    

}

extension FunctionViewModel {
    
    // MARK: - 创建功能cell
    func dequeueReusableCell(_ identifier: String,_ collectionView: UICollectionView,_ indexPath: IndexPath) -> UICollectionViewCell {
        let functionCell = collectionView.dequeueReusableCell(withReuseIdentifier: identifier, for: indexPath) as! FunctionCollectionViewCell
        functionCell.updateFunctionCell(itemArrays[indexPath.item])
        return functionCell
    }
}
