//
//  PublicModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/12.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import Foundation
import SwiftyJSON

class UCN {
    
    var code : String!
    var name : String!
    var uuid : String!
    
    init(_ code: String, _ name: String ,_ uuid: String) {
        self.code = code
        self.name = name
        self.uuid = uuid
    }
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        code = json["code"].stringValue
        name = json["name"].stringValue
        uuid = json["uuid"].stringValue
    }
    
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if code != nil{
            dictionary["code"] = code
        }
        if name != nil{
            dictionary["name"] = name
        }
        if uuid != nil{
            dictionary["uuid"] = uuid
        }
        return dictionary
    }
}


class Paging{
    
    var page : Int!
    var pageCount : Int!
    var pageSize : Int!
    var recordCount : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        page = json["page"].intValue
        pageCount = json["pageCount"].intValue
        pageSize = json["pageSize"].intValue
        recordCount = json["recordCount"].intValue
    }
    
    /**
     * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
     */
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if page != nil{
            dictionary["page"] = page
        }
        if pageCount != nil{
            dictionary["pageCount"] = pageCount
        }
        if pageSize != nil{
            dictionary["pageSize"] = pageSize
        }
        if recordCount != nil{
            dictionary["recordCount"] = recordCount
        }
        return dictionary
    }
    
    
}
