//
//	ProjectSponsorsModel.swift
//
//	Create by 云霄 曹 on 11/1/2018
//	Copyright © 2018. All rights reserved.

//来源、服务类型、优先级

import Foundation 
import SwiftyJSON


class ProjectSponsorsModel : NSObject{

	var data : [String]!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		data = [String]()
		let dataArray = json["data"].arrayValue
		for dataJson in dataArray{
			data.append(dataJson.stringValue)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

	/**
	 * Returns all the available property values in the form of [String:Any] object where the key is the approperiate json key and the value is the value of the corresponding property
	 */
	func toDictionary() -> [String:Any]
	{
        var dictionary = [String:Any]()
		if data != nil{
			dictionary["data"] = data
		}
		if message != nil{
			dictionary["message"] = message
		}
		if success != nil{
			dictionary["success"] = success
		}
		return dictionary
	}
}
