//
//	LocationModel.swift
//
//	Create by 云霄 曹 on 11/1/2018
//	Copyright © 2018. All rights reserved.

import Foundation 
import SwiftyJSON

class LocationModel{

	var data : LocationData!
	var message : String!
	var success : Bool!


	/**
	 * Instantiate the instance using the passed json values to set the properties values
	 */
	init(fromJson json: JSON!){
		if json.isEmpty{
			return
		}
		let dataJson = json["data"]
		if !dataJson.isEmpty{
			data = LocationData(fromJson: dataJson)
		}
		message = json["message"].stringValue
		success = json["success"].boolValue
	}

}

class LocationData{
    
    var paging : Paging!
    var records : [LocationRecord]!
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        let pagingJson = json["paging"]
        if !pagingJson.isEmpty{
            paging = Paging(fromJson: pagingJson)
        }
        records = [LocationRecord]()
        let recordsArray = json["records"].arrayValue
        for recordsJson in recordsArray{
            let value = LocationRecord(fromJson: recordsJson)
            records.append(value)
        }
    }
}


class LocationRecord{
    
    var buldingName : AnyObject!
    var code : String!
    var createId : String!
    var createOperName : String!
    var createTime : String!
    var enabled : Bool!
    var floorName : AnyObject!
    var lastModifyId : String!
    var lastModifyOperName : String!
    var lastModifyTime : String!
    var name : String!
    var positionCategory : AnyObject!
    var store : AnyObject!
    var uuid : String!
    var version : Int!
    
    
    /**
     * Instantiate the instance using the passed json values to set the properties values
     */
    init(fromJson json: JSON!){
        if json.isEmpty{
            return
        }
        buldingName = json["buldingName"] as AnyObject
        code = json["code"].stringValue
        createId = json["create_id"].stringValue
        createOperName = json["create_operName"].stringValue
        createTime = json["create_time"].stringValue
        enabled = json["enabled"].boolValue
        floorName = json["floorName"] as AnyObject
        lastModifyId = json["lastModify_id"].stringValue
        lastModifyOperName = json["lastModify_operName"].stringValue
        lastModifyTime = json["lastModify_time"].stringValue
        name = json["name"].stringValue
        positionCategory = json["positionCategory"] as AnyObject
        store = json["store"] as AnyObject
        uuid = json["uuid"].stringValue
        version = json["version"].intValue
    }
    
}
