//
//  DeviceQueryModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/11.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import SwiftyJSON


open class DeviceQueryModel {

    var codeEquals : String!
    var nameLike : String!
    var order : DeviceOrder!
    var page : Int!
    var pageSize : Int!
    var stateEquals : String! = "true"
    var storeIdEquals: String!
    
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if codeEquals != nil{
            dictionary["codeEquals"] = codeEquals
        }
        if nameLike != nil{
            dictionary["nameLike"] = nameLike
        }
        if storeIdEquals != nil{
            dictionary["storeIdEquals"] = storeIdEquals
        }
        if order != nil{
            dictionary["order"] = order.toDictionary()
        }
        if page != nil{
            dictionary["page"] = page
        }
        if pageSize != nil{
            dictionary["pageSize"] = pageSize
        }
        if stateEquals != nil{
            dictionary["stateEquals"] = stateEquals
        }
        return dictionary
    }
}


class DeviceOrder{
    
    var direction : String!
    var field : String!
    
    func toDictionary() -> [String:Any]
    {
        var dictionary = [String:Any]()
        if direction != nil{
            dictionary["direction"] = direction
        }
        if field != nil{
            dictionary["field"] = field
        }
        return dictionary
    }
    
}
