//
//  PhotoAttachmentViewModel.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/5.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class PhotoAttachmentViewModel: BaseViewModel {

    /// 图片附件
    lazy final var photoAttachments: Array<PhotoAttachmentModel> = { () -> Array<PhotoAttachmentModel<Any>> in
        var photoAttachments = Array<PhotoAttachmentModel<Any>>()
        return photoAttachments
    }()
}

extension PhotoAttachmentViewModel {
    func dequeueReusableCell(_ identifier: String, _ indexPath: IndexPath, _ collectionView: UICollectionView) -> UICollectionViewCell {
        let attachmentCell = collectionView.dequeueReusableCell(withReuseIdentifier: identifier, for: indexPath) as! PhotoAttachmentCollectionViewCell
        attachmentCell.updateAttachmentCell(photoAttachments[indexPath.item], indexPath)
        return attachmentCell
    }
}

