//
//  PermissionsManager.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/25.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import SwiftyJSON

class PermissionsManager: NSObject {
    
    // MARK: - 子工单查看权
    class func childViewPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == ChildBillViewPermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
    
    // MARK: - 子工单保存权
    class func saveChildPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == ChildBillSavePermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
    
    // MARK: - 子工单完成权
    class func finishChildPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == ChildBillFinishPermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
    
    // MARK: - 子工单领取权
    class func drawChildPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == ChildBillDrewPermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
    
    // MARK: - 主工单转交权
    class func transferBillPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == BillTransferPermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
    
    // MARK: - 主工单完成权
    class func finishBillPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == BillFinishPermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
    
    // MARK: - 主工单新建权
    class func createBillPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == BillCreatePermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
    
    // MARK: - 工单菜单查看权
    class func billViewPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == BillViewPermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
    
    // MARK: - 待办菜单查看权
    class func todoViewPermissions() ->Bool {
        let array = AppManager.shareInstance.userModel?.permissions.filter { (string) -> Bool in
            return string == TodoViewPermissions
        }
        guard array != nil else {
            return false
        }
        return Bool(exactly: NSNumber(value: array!.count))!
    }
}




















