//
//  BaseViewModel.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/11.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit
import RxCocoa
import RxSwift


class BaseViewModel: NSObject {
    
    
    // MARK: - 获取登录人所属项目,可能为空
    func getStoreByUser() {
        Network.request(target: .QueryStoreByUserId, success: { (json) in
            let resultModel = StoreResultModel(fromJson: json)
            if resultModel.success {
                AppManager.shareInstance.userStoreModel = resultModel.data
            }else {
                ShowMessage(resultModel.message)
            }
        }, failure: { (error) in
            ShowMessage(error.localizedDescription)
        })
    }

    // MARK: - 检查版本更新
    func updateVersion() ->Observable<(Bool,String,String)> {
        return Observable.create({ (observer) -> Disposable in
            Network.request(target: .UpdateVersion(), success: { (json) in
                let resultModel = UpdateVersionModel.deserialize(from: json.dictionaryObject)
                guard resultModel?.data != nil else {
                    ShowMessage("数据异常")
                    return
                }
                if resultModel!.success {
                    let index = NSString.compareVersion(UIDevice.appVersion(), string: resultModel?.data.version)
                    if index == -1 {
                        if resultModel?.data.forceUpdate == 1 {
                            observer.onNext((true, resultModel!.data.url,resultModel!.data.version))
                        }else {
                            observer.onNext((false, resultModel!.data.url,resultModel!.data.version))
                        }
                    }
                }else {
                    ShowMessage(resultModel!.message)
                }
            }, failure: { (error) in
                ShowMessage(error.localizedDescription)
            })
            return Disposables.create()
        })
    }
}
