//
//  BaseNavigationController.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/11/29.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import UIKit

class BaseNavigationController: UINavigationController {

    override func viewDidLoad() {
        super.viewDidLoad()

    }

    // MARK: - 自定义push方法
    override func pushViewController(_ viewController: UIViewController, animated: Bool) {
        if childViewControllers.count > 0 {
            addBackButtonItem(viewController);
        }
        super.pushViewController(viewController, animated: animated)
    }
    
    // MARK: - 添加返回按钮
    fileprivate func addBackButtonItem(_ viewController: UIViewController) {
        let backBtn = UIBarButtonItem(image: UIImage(named: "back_icon"), style: .done, target: self, action: #selector(BaseNavigationController.backBtnClick))
        viewController.navigationItem.leftBarButtonItem = backBtn
        viewController.hidesBottomBarWhenPushed = true
    }

    //MARK: 默认返回上一层页面
    @objc open func backBtnClick() {
        popViewController(animated: true)
    }
}
