//
//  BaseEditImageView.swift
//  IFS
//
//  Created by 曹云霄 on 2018/2/1.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class BaseEditImageView: UIImageView {
    
    let currentScale: CGFloat! = 1;
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.isUserInteractionEnabled = true
        self.contentMode = .scaleAspectFit
        self.autoresizingMask = .flexibleTopMargin
        let pinchGes = UIPinchGestureRecognizer(target: self, action: #selector(BaseEditImageView.backGroundViewPinchAction))
        pinchGes.delegate = self
        self.addGestureRecognizer(pinchGes)
        let panGes = UIPanGestureRecognizer(target: self, action: #selector(BaseEditImageView.backGroundViewPanAction))
        panGes.delegate = self
        self.addGestureRecognizer(panGes)
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

extension BaseEditImageView: UIGestureRecognizerDelegate {
    
    @objc func backGroundViewPinchAction(gesture :UIPinchGestureRecognizer) {
        if gesture.state == .began || gesture.state == .changed {
            self.transform = CGAffineTransform.scaledBy(self.transform)(x: gesture.scale, y: gesture.scale)
            gesture.scale = 1
        }
    }
    
    @objc func backGroundViewPanAction(gesture: UIPanGestureRecognizer) {
        if gesture.state == .began || gesture.state == .changed {
            let translation = gesture.translation(in: self.superview)
            self.center = CGPoint(x: self.center.x + translation.x, y: self.center.y + translation.y)
            gesture.setTranslation(CGPoint.zero, in: self.superview)
        }
    }
    
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
        return true
    }
}
