//
//  MBProgressView.swift
//  GitHub
//
//  Created by 曹云霄 on 2017/12/5.
//  Copyright © 2017年 曹云霄. All rights reserved.
//

import Foundation
import UIKit
import MBProgressHUD

// MARK: - 创建公共MBProgressHUD
func BaseMBProgressView(_ view: UIView) -> MBProgressHUD {
    let hud = MBProgressHUD.showAdded(to: view, animated: true)
    hud.removeFromSuperViewOnHide = true
    hud.margin = 10
    return hud
}

// MARK: - 纯文本显示框,默认主Window
func ShowMessage(_ message: String) {
    let hud = BaseMBProgressView(kWindow)
    hud.mode = MBProgressHUDMode.text
    hud.label.text = "加载中"
    hud.detailsLabel.text = message
    hud.hide(animated: true, afterDelay: 3)
}

// MARK: - 菊花加载框,默认颜色和主题色相同
func ShowLoadingView(_ view: UIView?) {
    var hud: MBProgressHUD?
    if let view = view {
        hud = BaseMBProgressView(view)
    }else {
        hud = BaseMBProgressView(kWindow)
    }
    hud!.mode = MBProgressHUDMode.indeterminate
    hud!.bezelView.style = .solidColor
    hud!.bezelView.backgroundColor = UIColor.clear
    hud!.contentColor = kNavColor
}

// MARK: - 销毁对应View上所有MBProgressHUD
func HideLoadingView(_ view: UIView?) {
    if let view = view {
        MBProgressHUD.hide(for: view, animated: true)
    }else {
        MBProgressHUD.hide(for: kWindow, animated: true)
    }
}













