//
//  HomeViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import SnapKit

class HomeViewController: BaseViewController {

    
    /// 子视图背景View
    @IBOutlet weak var contentBgView: UIView!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        addChildContentVc()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        contentBgView.addAngle(10.0)
        contentBgView.addShadow(UIColor.black)
    }

    // MARK: - 添加子控制器到主控制器
    fileprivate func addChildContentVc() {
        let homeContentVc = HomeContentViewController.instantiateViewController(.Home)
        addChildViewController(homeContentVc)
        contentBgView.addSubview(homeContentVc.view)
        homeContentVc.view.snp.makeConstraints { (make) in
            make.edges.equalTo(contentBgView)
        }
    }
}
