//
//  HomeContentViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/2.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class HomeContentViewController: BaseViewController {

    /// 首页未开始、已领单
    @IBOutlet weak var contentSegmented: UISegmentedControl!
    /// 内容ScrollView
    @IBOutlet weak var contentScrollView: UIScrollView!
    
    /// 当前子视图
    var currentVc: BaseTableViewPullController!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        addChildContentVc()
    }
    
    // MARK: - 添加子控制器到主控制器
    fileprivate func addChildContentVc() {
        for i in 0..<contentSegmented.numberOfSegments {
            let homeTableVc = HomeTableViewController.instantiateViewController(.Home) as! BaseTableViewPullController
            addChildViewController(homeTableVc)
            if i == kZERO {
                currentVc = homeTableVc
                homeTableVc.view.setx(x: 0)
                homeTableVc.view.seth(h: contentScrollView.height)
                homeTableVc.view.setw(w: contentScrollView.width)
                contentScrollView.addSubview(homeTableVc.view)
            }
        }
        contentScrollView.contentSize = CGSize(width: contentSegmented.numberOfSegments * Int(kWidth), height: 0)
        contentScrollView.isPagingEnabled = true
    }
    
    // MARK: - 滚动结束取出下标对应控制器
    fileprivate func selectedCurrentVc(_ index: Int,_ scrollView: UIScrollView) {
        let tableViewVc = childViewControllers[index]
        currentVc = tableViewVc as! BaseTableViewPullController
        tableViewVc.view.setx(x: scrollView.contentOffset.x)
        tableViewVc.view.seth(h: contentScrollView.height)
        tableViewVc.view.setw(w: contentScrollView.width)
        contentScrollView.addSubview(tableViewVc.view)
    }
    
    // MARK: - UISegmentedControl切换事件
    @IBAction func segmentedControlClickAction(_ sender: UISegmentedControl) {
        let offset = sender.selectedSegmentIndex * Int(contentScrollView.width)
        contentScrollView.setContentOffset(CGPoint(x: offset, y: 0), animated: true)
    }
}

extension HomeContentViewController: UIScrollViewDelegate {
    
    // MARK: - 滑动结束,获取当前下标（是人为拖拽scrollView导致滚动完毕，才会调用这个方法）
    func scrollViewDidEndDecelerating(_ scrollView: UIScrollView) {
        scrollViewDidEndScrollingAnimation(scrollView)
        let offset = scrollView.contentOffset;
        let index: Int  = Int(offset.x / scrollView.width);
        contentSegmented.selectedSegmentIndex = index
    }
    
    // MARK: - 滑动结束,获取当前下标（如果不是人为拖拽scrollView导致滚动完毕，才会调用这个方法）
    func scrollViewDidEndScrollingAnimation(_ scrollView: UIScrollView) {
        let offset = scrollView.contentOffset;
        let index: Int  = Int(offset.x / scrollView.width);
        selectedCurrentVc(index,scrollView)
    }
}


























