//
//  TodoViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/5.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit

class TodoViewController: BaseTableViewPullController {

    /// TodoViewModel
    lazy final var todoViewModel: TodoViewModel = {
        var todoViewModel = TodoViewModel()
        return todoViewModel
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()

        tableViewAnimationHeight()
    }

    // MARK: - 加载数据
    override func loadWebDataSource() {
        endRefresh()
    }
    
    // MARK: - 设置tableview高度
    fileprivate func tableViewAnimationHeight() {
        tableView.rowHeight = UITableViewAutomaticDimension
        tableView.estimatedRowHeight = 80.0
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        return todoViewModel.dequeueReusableCell(TodoTableViewCell.name(),indexPath,tableView)
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 10
    }
    
}
