//
//  RepairOrderViewController.swift
//  IFS
//
//  Created by 曹云霄 on 2018/1/3.
//  Copyright © 2018年 上海勾芒信息科技有限公司. All rights reserved.
//

import UIKit
import RxCocoa
import RxSwift

class RepairOrderViewController: BaseTableViewPullController {

    /// RxSwift自动释放
    let disposeBag = DisposeBag()
    /// 新建工单
    @IBOutlet weak var addOrderButton: UIButton!
    /// 日期选择
    @IBOutlet weak var dateChooseButton: UIButton!
    /// 状态选择
    @IBOutlet weak var stateChooseButton: UIButton!
    /// 来源选择
    @IBOutlet weak var sourceChooseButton: UIButton!
    /// 优先级选择
    @IBOutlet weak var priorityChooseButton: UIButton!
    
    
    override func viewDidLoad() {
        super.viewDidLoad()

        uiConfigAction()
        bindingRxAction()
    }
    
    // MARK: - UI
    fileprivate func uiConfigAction() {
        title = "工单列表"
        dateChooseButton.addBorder(1.0, kGaryColor)
        stateChooseButton.addBorder(1.0, kGaryColor)
        sourceChooseButton.addBorder(1.0, kGaryColor)
        priorityChooseButton.addBorder(1.0, kGaryColor)
        dateChooseButton.horizontalCenterTitleAndImage(5)
        stateChooseButton.horizontalCenterTitleAndImage(5)
        sourceChooseButton.horizontalCenterTitleAndImage(5)
        priorityChooseButton.horizontalCenterTitleAndImage(5)
    }
    
    // MARK: - 绑定RxSwift事件
    fileprivate func bindingRxAction() {
        dateChooseButton.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.dateChooseButton.isSelected = true
            self?.dateChooseButton.addBorder(1.0, kBlueColor)
            YXPickerManager.share().showGeneralPickerView(kNavColor, dataArray: ["最近一周","最近两周","最近一个月"], defaultString: self?.dateChooseButton.currentTitle, commit: { (text, index) in
                self?.dateChooseButton.isSelected = false
                self?.dateChooseButton.addBorder(1.0, kGaryColor)
            }, cancel: {
                self?.dateChooseButton.isSelected = false
                self?.dateChooseButton.addBorder(1.0, kGaryColor)
            })
        }).disposed(by: disposeBag)
        
        stateChooseButton.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.stateChooseButton.isSelected = true
            self?.stateChooseButton.addBorder(1.0, kBlueColor)
            YXPickerManager.share().showGeneralPickerView(kNavColor, dataArray: ["全部状态","已完成","已提交","已取消"], defaultString: self?.stateChooseButton.currentTitle, commit: { (text, index) in
                self?.stateChooseButton.isSelected = false
                self?.stateChooseButton.addBorder(1.0, kGaryColor)
            }, cancel: {
                self?.stateChooseButton.isSelected = false
                self?.stateChooseButton.addBorder(1.0, kGaryColor)
            })
        }).disposed(by: disposeBag)
        
        sourceChooseButton.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.sourceChooseButton.isSelected = true
            self?.sourceChooseButton.addBorder(1.0, kBlueColor)
            YXPickerManager.share().showGeneralPickerView(kNavColor, dataArray: ["全部来源","内部","外部"], defaultString: self?.sourceChooseButton.currentTitle, commit: { (text, index) in
                self?.sourceChooseButton.isSelected = false
                self?.sourceChooseButton.addBorder(1.0, kGaryColor)
            }, cancel: {
                self?.sourceChooseButton.isSelected = false
                self?.sourceChooseButton.addBorder(1.0, kGaryColor)
            })
        }).disposed(by: disposeBag)
        
        priorityChooseButton.rx.controlEvent(UIControlEvents.touchUpInside).subscribe(onNext: {[weak self] (event) in
            self?.priorityChooseButton.isSelected = true
            self?.priorityChooseButton.addBorder(1.0, kBlueColor)
            YXPickerManager.share().showGeneralPickerView(kNavColor, dataArray: ["全部优先级","高","中","低"], defaultString: self?.priorityChooseButton.currentTitle, commit: { (text, index) in
                self?.priorityChooseButton.isSelected = false
                self?.priorityChooseButton.addBorder(1.0, kGaryColor)
            }, cancel: {
                self?.priorityChooseButton.isSelected = false
                self?.priorityChooseButton.addBorder(1.0, kGaryColor)
            })
        }).disposed(by: disposeBag)
    }

    // MARK: - 加载数据
    override func loadWebDataSource() {
        endRefresh()
    }

    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let orderCell = tableView.dequeueReusableCell(withIdentifier: RepairOrderTableViewCell.name(), for: indexPath)
        return orderCell
    }
    
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 10
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return 135
    }

}
